// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.newsfeed;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.newsfeed.responses.GetMentionsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Newsfeed.getMentions method
 */
public class NewsfeedGetMentionsQuery extends AbstractQueryBuilder<NewsfeedGetMentionsQuery, GetMentionsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NewsfeedGetMentionsQuery(VkApiClient client, UserActor actor) {
        super(client, "newsfeed.getMentions", GetMentionsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Owner ID.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public NewsfeedGetMentionsQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Earliest timestamp (in Unix time) of a post to return. By default, 24 hours ago.
     *
     * @param value value of "start time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("start_time")
    public NewsfeedGetMentionsQuery startTime(Integer value) {
        return unsafeParam("start_time", value);
    }

    /**
     * Latest timestamp (in Unix time) of a post to return. By default, the current time.
     *
     * @param value value of "end time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("end_time")
    public NewsfeedGetMentionsQuery endTime(Integer value) {
        return unsafeParam("end_time", value);
    }

    /**
     * Offset needed to return a specific subset of posts.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public NewsfeedGetMentionsQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of posts to return.
     *
     * @param value value of "count" parameter. Maximum is 50. Minimum is 0. By default 20.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public NewsfeedGetMentionsQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    @Override
    protected NewsfeedGetMentionsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
