// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.newsfeed;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Newsfeed.saveList method
 */
public class NewsfeedSaveListQuery extends AbstractQueryBuilder<NewsfeedSaveListQuery, Integer> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param title value of "title" parameter.
     */
    public NewsfeedSaveListQuery(VkApiClient client, UserActor actor, String title) {
        super(client, "newsfeed.saveList", Integer.class);
        accessToken(actor.getAccessToken());
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NewsfeedSaveListQuery(VkApiClient client, UserActor actor) {
        super(client, "newsfeed.saveList", Integer.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Numeric list identifier (if not sent, will be set automatically).
     *
     * @param value value of "list id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("list_id")
    public NewsfeedSaveListQuery listId(Integer value) {
        return unsafeParam("list_id", value);
    }

    /**
     * List name.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public NewsfeedSaveListQuery title(String value) {
        return unsafeParam("title", value);
    }

    /**
     * Reposts display on and off ('1' is for off).
     *
     * @param value value of "no reposts" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("no_reposts")
    public NewsfeedSaveListQuery noReposts(Boolean value) {
        return unsafeParam("no_reposts", value);
    }

    /**
     * sourceIds
     * Users and communities identifiers to be added to the list. Community identifiers must be negative numbers.
     *
     * @param value value of "source ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("source_ids")
    public NewsfeedSaveListQuery sourceIds(Long... value) {
        return unsafeParam("source_ids", value);
    }

    /**
     * Users and communities identifiers to be added to the list. Community identifiers must be negative numbers.
     *
     * @param value value of "source ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("source_ids")
    public NewsfeedSaveListQuery sourceIds(List<Long> value) {
        return unsafeParam("source_ids", value);
    }

    @Override
    protected NewsfeedSaveListQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("title", "access_token");
    }
}
