// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.newsfeed;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import com.vk.api.sdk.objects.newsfeed.IgnoreItemType;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Newsfeed.unignoreItem method
 */
public class NewsfeedUnignoreItemQuery extends AbstractQueryBuilder<NewsfeedUnignoreItemQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param type value of "type" parameter.
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param itemId value of "item id" parameter. Minimum is 0.
     */
    public NewsfeedUnignoreItemQuery(VkApiClient client, UserActor actor, IgnoreItemType type,
            Long ownerId, Integer itemId) {
        super(client, "newsfeed.unignoreItem", OkResponse.class);
        accessToken(actor.getAccessToken());
        type(type);
        ownerId(ownerId);
        itemId(itemId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NewsfeedUnignoreItemQuery(VkApiClient client, UserActor actor) {
        super(client, "newsfeed.unignoreItem", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Item type. Possible values: *'wall' - post on the wall,, *'tag' - tag on a photo,, *'profilephoto' - profile photo,, *'video' - video,, *'audio' - audio.
     *
     * @param value value of "type" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("type")
    public NewsfeedUnignoreItemQuery type(IgnoreItemType value) {
        return unsafeParam("type", value);
    }

    /**
     * Item owner's identifier (user or community), "Note that community id must be negative. 'owner_id=1' - user , 'owner_id=-1' - community "
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public NewsfeedUnignoreItemQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Item identifier
     *
     * @param value value of "item id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("item_id")
    public NewsfeedUnignoreItemQuery itemId(Integer value) {
        return unsafeParam("item_id", value);
    }

    /**
     * Track code of unignored item
     *
     * @param value value of "track code" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("track_code")
    public NewsfeedUnignoreItemQuery trackCode(String value) {
        return unsafeParam("track_code", value);
    }

    @Override
    protected NewsfeedUnignoreItemQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("item_id", "type", "owner_id", "access_token");
    }
}
