// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.notes;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Notes.delete method
 */
public class NotesDeleteQuery extends AbstractQueryBuilder<NotesDeleteQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param noteId value of "note id" parameter. Minimum is 0.
     */
    public NotesDeleteQuery(VkApiClient client, UserActor actor, Integer noteId) {
        super(client, "notes.delete", OkResponse.class);
        accessToken(actor.getAccessToken());
        noteId(noteId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NotesDeleteQuery(VkApiClient client, UserActor actor) {
        super(client, "notes.delete", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Note ID.
     *
     * @param value value of "note id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("note_id")
    public NotesDeleteQuery noteId(Integer value) {
        return unsafeParam("note_id", value);
    }

    @Override
    protected NotesDeleteQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("note_id", "access_token");
    }
}
