// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.notes;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.notes.GetSort;
import com.vk.api.sdk.objects.notes.responses.GetResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Notes.get method
 */
public class NotesGetQuery extends AbstractQueryBuilder<NotesGetQuery, GetResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NotesGetQuery(VkApiClient client, UserActor actor) {
        super(client, "notes.get", GetResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Note owner ID.
     *
     * @param value value of "user id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public NotesGetQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Set offset
     *
     * @param value value of "offset" parameter. Minimum is 0. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public NotesGetQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of notes to return.
     *
     * @param value value of "count" parameter. Maximum is 100. Minimum is 0. By default 20.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public NotesGetQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * Set sort
     *
     * @param value value of "sort" parameter. Minimum is 0. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sort")
    public NotesGetQuery sort(GetSort value) {
        return unsafeParam("sort", value);
    }

    /**
     * noteIds
     * Note IDs.
     *
     * @param value value of "note ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("note_ids")
    public NotesGetQuery noteIds(Integer... value) {
        return unsafeParam("note_ids", value);
    }

    /**
     * Note IDs.
     *
     * @param value value of "note ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("note_ids")
    public NotesGetQuery noteIds(List<Integer> value) {
        return unsafeParam("note_ids", value);
    }

    @Override
    protected NotesGetQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
