// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.notifications;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.notifications.SendMessageSendingMode;
import com.vk.api.sdk.objects.notifications.responses.SendMessageResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Notifications.sendMessage method
 */
public class NotificationsSendMessageQuery extends AbstractQueryBuilder<NotificationsSendMessageQuery, List<SendMessageResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param message value of "message" parameter.
     * @param userIds value of "user ids" parameter.
     */
    public NotificationsSendMessageQuery(VkApiClient client, ServiceActor actor, String message,
            Long... userIds) {
        super(client, "notifications.sendMessage", Utils.buildParametrizedType(List.class, SendMessageResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        message(message);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param message value of "message" parameter.
     * @param userIds value of "user ids" parameter.
     */
    public NotificationsSendMessageQuery(VkApiClient client, ServiceActor actor, String message,
            List<Long> userIds) {
        super(client, "notifications.sendMessage", Utils.buildParametrizedType(List.class, SendMessageResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        message(message);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public NotificationsSendMessageQuery(VkApiClient client, ServiceActor actor) {
        super(client, "notifications.sendMessage", Utils.buildParametrizedType(List.class, SendMessageResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set message
     *
     * @param value value of "message" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message")
    public NotificationsSendMessageQuery message(String value) {
        return unsafeParam("message", value);
    }

    /**
     * Set fragment
     *
     * @param value value of "fragment" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fragment")
    public NotificationsSendMessageQuery fragment(String value) {
        return unsafeParam("fragment", value);
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public NotificationsSendMessageQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set random id
     *
     * @param value value of "random id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("random_id")
    public NotificationsSendMessageQuery randomId(Integer value) {
        return unsafeParam("random_id", value);
    }

    /**
     * Type of sending (delivering) notifications: 'immediately' - push and bell notifications will be delivered as soon as possible, 'delayed' - push and bell notifications will be delivered in the most comfortable time for the user, 'delayed_push' - only push notifications will be delivered in the most comfortable time, while the bell notifications will be delivered as soon as possible
     *
     * @param value value of "sending mode" parameter. By default immediately.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sending_mode")
    public NotificationsSendMessageQuery sendingMode(SendMessageSendingMode value) {
        return unsafeParam("sending_mode", value);
    }

    /**
     * userIds
     * Set user ids
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    public NotificationsSendMessageQuery userIds(Long... value) {
        return unsafeParam("user_ids", value);
    }

    /**
     * Set user ids
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    public NotificationsSendMessageQuery userIds(List<Long> value) {
        return unsafeParam("user_ids", value);
    }

    @Override
    protected NotificationsSendMessageQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("user_ids", "message", "access_token");
    }
}
