// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.orders;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.orders.responses.GetAmountResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Orders.getAmount method
 */
public class OrdersGetAmountQuery extends AbstractQueryBuilder<OrdersGetAmountQuery, List<GetAmountResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param userId value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @param votes value of "votes" parameter.
     */
    public OrdersGetAmountQuery(VkApiClient client, UserActor actor, Long userId, String... votes) {
        super(client, "orders.getAmount", Utils.buildParametrizedType(List.class, GetAmountResponse.class));
        accessToken(actor.getAccessToken());
        userId(userId);
        votes(votes);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param userId value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @param votes value of "votes" parameter.
     */
    public OrdersGetAmountQuery(VkApiClient client, UserActor actor, Long userId,
            List<String> votes) {
        super(client, "orders.getAmount", Utils.buildParametrizedType(List.class, GetAmountResponse.class));
        accessToken(actor.getAccessToken());
        userId(userId);
        votes(votes);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public OrdersGetAmountQuery(VkApiClient client, UserActor actor) {
        super(client, "orders.getAmount", Utils.buildParametrizedType(List.class, GetAmountResponse.class));
        accessToken(actor.getAccessToken());
    }

    /**
     * Set user id
     *
     * @param value value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public OrdersGetAmountQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * votes
     * Set votes
     *
     * @param value value of "votes" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("votes")
    public OrdersGetAmountQuery votes(String... value) {
        return unsafeParam("votes", value);
    }

    /**
     * Set votes
     *
     * @param value value of "votes" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("votes")
    public OrdersGetAmountQuery votes(List<String> value) {
        return unsafeParam("votes", value);
    }

    @Override
    protected OrdersGetAmountQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("votes", "user_id", "access_token");
    }
}
