// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.orders;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.orders.responses.GetUserSubscriptionsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Orders.getUserSubscriptions method
 */
public class OrdersGetUserSubscriptionsQuery extends AbstractQueryBuilder<OrdersGetUserSubscriptionsQuery, GetUserSubscriptionsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param userId value of "user id" parameter. Minimum is 1. Entity - owner
     *
     */
    public OrdersGetUserSubscriptionsQuery(VkApiClient client, ServiceActor actor, Long userId) {
        super(client, "orders.getUserSubscriptions", GetUserSubscriptionsResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        userId(userId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public OrdersGetUserSubscriptionsQuery(VkApiClient client, ServiceActor actor) {
        super(client, "orders.getUserSubscriptions", GetUserSubscriptionsResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set user id
     *
     * @param value value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public OrdersGetUserSubscriptionsQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    @Override
    protected OrdersGetUserSubscriptionsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("user_id", "access_token");
    }
}
