// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.orders;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.BoolResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Orders.updateSubscription method
 */
public class OrdersUpdateSubscriptionQuery extends AbstractQueryBuilder<OrdersUpdateSubscriptionQuery, BoolResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param userId value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @param subscriptionId value of "subscription id" parameter. Minimum is 0.
     * @param price value of "price" parameter. Minimum is 0.
     */
    public OrdersUpdateSubscriptionQuery(VkApiClient client, ServiceActor actor, Long userId,
            Integer subscriptionId, Integer price) {
        super(client, "orders.updateSubscription", BoolResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        userId(userId);
        subscriptionId(subscriptionId);
        price(price);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public OrdersUpdateSubscriptionQuery(VkApiClient client, ServiceActor actor) {
        super(client, "orders.updateSubscription", BoolResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set user id
     *
     * @param value value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public OrdersUpdateSubscriptionQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Set subscription id
     *
     * @param value value of "subscription id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("subscription_id")
    public OrdersUpdateSubscriptionQuery subscriptionId(Integer value) {
        return unsafeParam("subscription_id", value);
    }

    /**
     * Set price
     *
     * @param value value of "price" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("price")
    public OrdersUpdateSubscriptionQuery price(Integer value) {
        return unsafeParam("price", value);
    }

    @Override
    protected OrdersUpdateSubscriptionQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("subscription_id", "price", "user_id", "access_token");
    }
}
