// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.pages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.pages.responses.GetVersionResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Pages.getVersion method
 */
public class PagesGetVersionQuery extends AbstractQueryBuilder<PagesGetVersionQuery, GetVersionResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param versionId value of "version id" parameter.
     */
    public PagesGetVersionQuery(VkApiClient client, UserActor actor, Integer versionId) {
        super(client, "pages.getVersion", GetVersionResponse.class);
        accessToken(actor.getAccessToken());
        versionId(versionId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PagesGetVersionQuery(VkApiClient client, UserActor actor) {
        super(client, "pages.getVersion", GetVersionResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set version id
     *
     * @param value value of "version id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("version_id")
    public PagesGetVersionQuery versionId(Integer value) {
        return unsafeParam("version_id", value);
    }

    /**
     * ID of the community that owns the wiki page.
     *
     * @param value value of "group id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public PagesGetVersionQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set user id
     *
     * @param value value of "user id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public PagesGetVersionQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * '1' - to return the page as HTML
     *
     * @param value value of "need html" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("need_html")
    public PagesGetVersionQuery needHtml(Boolean value) {
        return unsafeParam("need_html", value);
    }

    @Override
    protected PagesGetVersionQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("version_id", "access_token");
    }
}
