// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.pages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Pages.save method
 */
public class PagesSaveQuery extends AbstractQueryBuilder<PagesSaveQuery, Integer> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PagesSaveQuery(VkApiClient client, UserActor actor) {
        super(client, "pages.save", Integer.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Text of the wiki page in wiki-format.
     *
     * @param value value of "text" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("text")
    public PagesSaveQuery text(String value) {
        return unsafeParam("text", value);
    }

    /**
     * Wiki page ID. The 'title' parameter can be passed instead of 'pid'.
     *
     * @param value value of "page id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("page_id")
    public PagesSaveQuery pageId(Integer value) {
        return unsafeParam("page_id", value);
    }

    /**
     * ID of the community that owns the wiki page.
     *
     * @param value value of "group id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public PagesSaveQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * User ID
     *
     * @param value value of "user id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public PagesSaveQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Wiki page title.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public PagesSaveQuery title(String value) {
        return unsafeParam("title", value);
    }

    @Override
    protected PagesSaveQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
