// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.copy method
 */
public class PhotosCopyQuery extends AbstractQueryBuilder<PhotosCopyQuery, Integer> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param photoId value of "photo id" parameter. Minimum is 0.
     */
    public PhotosCopyQuery(VkApiClient client, UserActor actor, Long ownerId, Integer photoId) {
        super(client, "photos.copy", Integer.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        photoId(photoId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosCopyQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.copy", Integer.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Photo's owner ID
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PhotosCopyQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Photo ID
     *
     * @param value value of "photo id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_id")
    public PhotosCopyQuery photoId(Integer value) {
        return unsafeParam("photo_id", value);
    }

    /**
     * For private photos
     *
     * @param value value of "access key" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("access_key")
    public PhotosCopyQuery accessKey(String value) {
        return unsafeParam("access_key", value);
    }

    @Override
    protected PhotosCopyQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("photo_id", "owner_id", "access_token");
    }
}
