// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.photos.responses.CreateAlbumResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.createAlbum method
 */
public class PhotosCreateAlbumQuery extends AbstractQueryBuilder<PhotosCreateAlbumQuery, CreateAlbumResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param title value of "title" parameter.
     */
    public PhotosCreateAlbumQuery(VkApiClient client, UserActor actor, String title) {
        super(client, "photos.createAlbum", CreateAlbumResponse.class);
        accessToken(actor.getAccessToken());
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosCreateAlbumQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.createAlbum", CreateAlbumResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Album title.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public PhotosCreateAlbumQuery title(String value) {
        return unsafeParam("title", value);
    }

    /**
     * ID of the community in which the album will be created.
     *
     * @param value value of "group id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public PhotosCreateAlbumQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Album description.
     *
     * @param value value of "description" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("description")
    public PhotosCreateAlbumQuery description(String value) {
        return unsafeParam("description", value);
    }

    /**
     * Set upload by admins only
     *
     * @param value value of "upload by admins only" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("upload_by_admins_only")
    public PhotosCreateAlbumQuery uploadByAdminsOnly(Boolean value) {
        return unsafeParam("upload_by_admins_only", value);
    }

    /**
     * Set comments disabled
     *
     * @param value value of "comments disabled" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("comments_disabled")
    public PhotosCreateAlbumQuery commentsDisabled(Boolean value) {
        return unsafeParam("comments_disabled", value);
    }

    /**
     * privacyView
     * Set privacy view
     *
     * @param value value of "privacy view" parameter. By default all.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_view")
    public PhotosCreateAlbumQuery privacyView(String... value) {
        return unsafeParam("privacy_view", value);
    }

    /**
     * Set privacy view
     *
     * @param value value of "privacy view" parameter. By default all.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_view")
    public PhotosCreateAlbumQuery privacyView(List<String> value) {
        return unsafeParam("privacy_view", value);
    }

    /**
     * privacyComment
     * Set privacy comment
     *
     * @param value value of "privacy comment" parameter. By default all.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_comment")
    public PhotosCreateAlbumQuery privacyComment(String... value) {
        return unsafeParam("privacy_comment", value);
    }

    /**
     * Set privacy comment
     *
     * @param value value of "privacy comment" parameter. By default all.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_comment")
    public PhotosCreateAlbumQuery privacyComment(List<String> value) {
        return unsafeParam("privacy_comment", value);
    }

    @Override
    protected PhotosCreateAlbumQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("title", "access_token");
    }
}
