// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.GetUploadServerResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.getOwnerCoverPhotoUploadServer method
 */
public class PhotosGetOwnerCoverPhotoUploadServerQuery extends AbstractQueryBuilder<PhotosGetOwnerCoverPhotoUploadServerQuery, GetUploadServerResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosGetOwnerCoverPhotoUploadServerQuery(VkApiClient client, GroupActor actor) {
        super(client, "photos.getOwnerCoverPhotoUploadServer", GetUploadServerResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosGetOwnerCoverPhotoUploadServerQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.getOwnerCoverPhotoUploadServer", GetUploadServerResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of community that owns the album (if the photo will be uploaded to a community album).
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public PhotosGetOwnerCoverPhotoUploadServerQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * X coordinate of the left-upper corner
     *
     * @param value value of "crop x" parameter. Minimum is 0. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("crop_x")
    public PhotosGetOwnerCoverPhotoUploadServerQuery cropX(Integer value) {
        return unsafeParam("crop_x", value);
    }

    /**
     * Y coordinate of the left-upper corner
     *
     * @param value value of "crop y" parameter. Minimum is 0. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("crop_y")
    public PhotosGetOwnerCoverPhotoUploadServerQuery cropY(Integer value) {
        return unsafeParam("crop_y", value);
    }

    /**
     * X coordinate of the right-bottom corner
     *
     * @param value value of "crop x2" parameter. Minimum is 0. By default 795.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("crop_x2")
    public PhotosGetOwnerCoverPhotoUploadServerQuery cropX2(Integer value) {
        return unsafeParam("crop_x2", value);
    }

    /**
     * Y coordinate of the right-bottom corner
     *
     * @param value value of "crop y2" parameter. Minimum is 0. By default 200.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("crop_y2")
    public PhotosGetOwnerCoverPhotoUploadServerQuery cropY2(Integer value) {
        return unsafeParam("crop_y2", value);
    }

    /**
     * Set is video cover
     *
     * @param value value of "is video cover" parameter. By default false.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_video_cover")
    public PhotosGetOwnerCoverPhotoUploadServerQuery isVideoCover(Boolean value) {
        return unsafeParam("is_video_cover", value);
    }

    @Override
    protected PhotosGetOwnerCoverPhotoUploadServerQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
