// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.makeCover method
 */
public class PhotosMakeCoverQuery extends AbstractQueryBuilder<PhotosMakeCoverQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param photoId value of "photo id" parameter.
     */
    public PhotosMakeCoverQuery(VkApiClient client, UserActor actor, Integer photoId) {
        super(client, "photos.makeCover", OkResponse.class);
        accessToken(actor.getAccessToken());
        photoId(photoId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosMakeCoverQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.makeCover", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the user or community that owns the photo.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PhotosMakeCoverQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Photo ID.
     *
     * @param value value of "photo id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_id")
    public PhotosMakeCoverQuery photoId(Integer value) {
        return unsafeParam("photo_id", value);
    }

    /**
     * Album ID.
     *
     * @param value value of "album id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("album_id")
    public PhotosMakeCoverQuery albumId(Integer value) {
        return unsafeParam("album_id", value);
    }

    @Override
    protected PhotosMakeCoverQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("photo_id", "access_token");
    }
}
