// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.move method
 */
public class PhotosMoveQuery extends AbstractQueryBuilder<PhotosMoveQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param targetAlbumId value of "target album id" parameter.
     * @param photoIds value of "photo ids" parameter.
     */
    public PhotosMoveQuery(VkApiClient client, UserActor actor, Integer targetAlbumId,
            Integer... photoIds) {
        super(client, "photos.move", OkResponse.class);
        accessToken(actor.getAccessToken());
        targetAlbumId(targetAlbumId);
        photoIds(photoIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param targetAlbumId value of "target album id" parameter.
     * @param photoIds value of "photo ids" parameter.
     */
    public PhotosMoveQuery(VkApiClient client, UserActor actor, Integer targetAlbumId,
            List<Integer> photoIds) {
        super(client, "photos.move", OkResponse.class);
        accessToken(actor.getAccessToken());
        targetAlbumId(targetAlbumId);
        photoIds(photoIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosMoveQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.move", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the user or community that owns the photo.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PhotosMoveQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * ID of the album to which the photo will be moved.
     *
     * @param value value of "target album id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_album_id")
    public PhotosMoveQuery targetAlbumId(Integer value) {
        return unsafeParam("target_album_id", value);
    }

    /**
     * photoIds
     * Set photo ids
     *
     * @param value value of "photo ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_ids")
    public PhotosMoveQuery photoIds(Integer... value) {
        return unsafeParam("photo_ids", value);
    }

    /**
     * Set photo ids
     *
     * @param value value of "photo ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_ids")
    public PhotosMoveQuery photoIds(List<Integer> value) {
        return unsafeParam("photo_ids", value);
    }

    @Override
    protected PhotosMoveQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("photo_ids", "target_album_id", "access_token");
    }
}
