// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.putTag method
 */
public class PhotosPutTagQuery extends AbstractQueryBuilder<PhotosPutTagQuery, Integer> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param photoId value of "photo id" parameter. Minimum is 0.
     * @param userId value of "user id" parameter. Entity - owner
     *
     */
    public PhotosPutTagQuery(VkApiClient client, UserActor actor, Integer photoId, Long userId) {
        super(client, "photos.putTag", Integer.class);
        accessToken(actor.getAccessToken());
        photoId(photoId);
        userId(userId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosPutTagQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.putTag", Integer.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the user or community that owns the photo.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PhotosPutTagQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Photo ID.
     *
     * @param value value of "photo id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_id")
    public PhotosPutTagQuery photoId(Integer value) {
        return unsafeParam("photo_id", value);
    }

    /**
     * ID of the user to be tagged.
     *
     * @param value value of "user id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public PhotosPutTagQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Upper left-corner coordinate of the tagged area (as a percentage of the photo's width).
     *
     * @param value value of "x" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("x")
    public PhotosPutTagQuery x(Number value) {
        return unsafeParam("x", value);
    }

    /**
     * Upper left-corner coordinate of the tagged area (as a percentage of the photo's height).
     *
     * @param value value of "y" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("y")
    public PhotosPutTagQuery y(Number value) {
        return unsafeParam("y", value);
    }

    /**
     * Lower right-corner coordinate of the tagged area (as a percentage of the photo's width).
     *
     * @param value value of "x2" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("x2")
    public PhotosPutTagQuery x2(Number value) {
        return unsafeParam("x2", value);
    }

    /**
     * Lower right-corner coordinate of the tagged area (as a percentage of the photo's height).
     *
     * @param value value of "y2" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("y2")
    public PhotosPutTagQuery y2(Number value) {
        return unsafeParam("y2", value);
    }

    @Override
    protected PhotosPutTagQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("photo_id", "user_id", "access_token");
    }
}
