// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.photos;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.photos.responses.SaveMarketAlbumPhotoResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Photos.saveMarketAlbumPhoto method
 */
public class PhotosSaveMarketAlbumPhotoQuery extends AbstractQueryBuilder<PhotosSaveMarketAlbumPhotoQuery, List<SaveMarketAlbumPhotoResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param photo value of "photo" parameter.
     * @param server value of "server" parameter. Minimum is 0.
     * @param hash value of "hash" parameter.
     */
    public PhotosSaveMarketAlbumPhotoQuery(VkApiClient client, UserActor actor, Long groupId,
            String photo, Integer server, String hash) {
        super(client, "photos.saveMarketAlbumPhoto", Utils.buildParametrizedType(List.class, SaveMarketAlbumPhotoResponse.class));
        accessToken(actor.getAccessToken());
        groupId(groupId);
        photo(photo);
        server(server);
        hash(hash);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PhotosSaveMarketAlbumPhotoQuery(VkApiClient client, UserActor actor) {
        super(client, "photos.saveMarketAlbumPhoto", Utils.buildParametrizedType(List.class, SaveMarketAlbumPhotoResponse.class));
        accessToken(actor.getAccessToken());
    }

    /**
     * Community ID.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public PhotosSaveMarketAlbumPhotoQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Parameter returned when photos are [vk.com/dev/upload_files|uploaded to server].
     *
     * @param value value of "photo" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo")
    public PhotosSaveMarketAlbumPhotoQuery photo(String value) {
        return unsafeParam("photo", value);
    }

    /**
     * Parameter returned when photos are [vk.com/dev/upload_files|uploaded to server].
     *
     * @param value value of "server" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("server")
    public PhotosSaveMarketAlbumPhotoQuery server(Integer value) {
        return unsafeParam("server", value);
    }

    /**
     * Parameter returned when photos are [vk.com/dev/upload_files|uploaded to server].
     *
     * @param value value of "hash" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("hash")
    public PhotosSaveMarketAlbumPhotoQuery hash(String value) {
        return unsafeParam("hash", value);
    }

    @Override
    protected PhotosSaveMarketAlbumPhotoQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("photo", "group_id", "server", "hash", "access_token");
    }
}
