// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.polls;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.polls.CreateBackgroundId;
import com.vk.api.sdk.objects.polls.responses.CreateResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Polls.create method
 */
public class PollsCreateQuery extends AbstractQueryBuilder<PollsCreateQuery, CreateResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PollsCreateQuery(VkApiClient client, UserActor actor) {
        super(client, "polls.create", CreateResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Question text
     *
     * @param value value of "question" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("question")
    public PollsCreateQuery question(String value) {
        return unsafeParam("question", value);
    }

    /**
     * '1' - anonymous poll, participants list is hidden,, '0' - public poll, participants list is available,, Default value is '0'.
     *
     * @param value value of "is anonymous" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_anonymous")
    public PollsCreateQuery isAnonymous(Boolean value) {
        return unsafeParam("is_anonymous", value);
    }

    /**
     * Set is multiple
     *
     * @param value value of "is multiple" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_multiple")
    public PollsCreateQuery isMultiple(Boolean value) {
        return unsafeParam("is_multiple", value);
    }

    /**
     * Set end date
     *
     * @param value value of "end date" parameter. Minimum is 1550700000.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("end_date")
    public PollsCreateQuery endDate(Integer value) {
        return unsafeParam("end_date", value);
    }

    /**
     * If a poll will be added to a communty it is required to send a negative group identifier. Current user by default.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PollsCreateQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Set app id
     *
     * @param value value of "app id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("app_id")
    public PollsCreateQuery appId(Integer value) {
        return unsafeParam("app_id", value);
    }

    /**
     * Available answers list, for example: " ["yes","no","maybe"]", There can be from 1 to 10 answers.
     *
     * @param value value of "add answers" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("add_answers")
    public PollsCreateQuery addAnswers(String value) {
        return unsafeParam("add_answers", value);
    }

    /**
     * Set photo id
     *
     * @param value value of "photo id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_id")
    public PollsCreateQuery photoId(Integer value) {
        return unsafeParam("photo_id", value);
    }

    /**
     * Set background id
     *
     * @param value value of "background id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("background_id")
    public PollsCreateQuery backgroundId(CreateBackgroundId value) {
        return unsafeParam("background_id", value);
    }

    /**
     * Set disable unvote
     *
     * @param value value of "disable unvote" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("disable_unvote")
    public PollsCreateQuery disableUnvote(Boolean value) {
        return unsafeParam("disable_unvote", value);
    }

    @Override
    protected PollsCreateQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
