// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.prettycards;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.prettycards.responses.DeleteResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for PrettyCards.delete method
 */
public class PrettyCardsDeleteQuery extends AbstractQueryBuilder<PrettyCardsDeleteQuery, DeleteResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param cardId value of "card id" parameter.
     */
    public PrettyCardsDeleteQuery(VkApiClient client, UserActor actor, Long ownerId,
            Integer cardId) {
        super(client, "prettyCards.delete", DeleteResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        cardId(cardId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public PrettyCardsDeleteQuery(VkApiClient client, UserActor actor) {
        super(client, "prettyCards.delete", DeleteResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set owner id
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public PrettyCardsDeleteQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Set card id
     *
     * @param value value of "card id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("card_id")
    public PrettyCardsDeleteQuery cardId(Integer value) {
        return unsafeParam("card_id", value);
    }

    @Override
    protected PrettyCardsDeleteQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("card_id", "owner_id", "access_token");
    }
}
