// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.secure;

import com.vk.api.sdk.client.AbstractSecureQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Secure.addAppEvent method
 */
public class SecureAddAppEventQuery extends AbstractSecureQueryBuilder<SecureAddAppEventQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param activityId value of "activity id" parameter. Minimum is 0.
     */
    public SecureAddAppEventQuery(VkApiClient client, ServiceActor actor, Integer activityId) {
        super(client, "secure.addAppEvent", OkResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        activityId(activityId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public SecureAddAppEventQuery(VkApiClient client, ServiceActor actor) {
        super(client, "secure.addAppEvent", OkResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * ID of a user to save the data
     *
     * @param value value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public SecureAddAppEventQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * There are 2 default activities: , * 1 - level. Works similar to ,, * 2 - points, saves points amount, Any other value is for saving completed missions
     *
     * @param value value of "activity id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("activity_id")
    public SecureAddAppEventQuery activityId(Integer value) {
        return unsafeParam("activity_id", value);
    }

    /**
     * Depends on activity_id: * 1 - number, current level number,, * 2 - number, current user's points amount, , Any other value is ignored
     *
     * @param value value of "value" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("value")
    public SecureAddAppEventQuery value(Integer value) {
        return unsafeParam("value", value);
    }

    @Override
    protected SecureAddAppEventQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("activity_id", "access_token");
    }
}
