// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.secure;

import com.vk.api.sdk.client.AbstractSecureQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.secure.responses.SetCounterArrayResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Secure.setCounter method
 */
public class SecureSetCounterQueryWithArray extends AbstractSecureQueryBuilder<SecureSetCounterQueryWithArray, List<SetCounterArrayResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public SecureSetCounterQueryWithArray(VkApiClient client, ServiceActor actor) {
        super(client, "secure.setCounter", Utils.buildParametrizedType(List.class, SetCounterArrayResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set user id
     *
     * @param value value of "user id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public SecureSetCounterQueryWithArray userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Counter value.
     *
     * @param value value of "counter" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("counter")
    public SecureSetCounterQueryWithArray counter(Integer value) {
        return unsafeParam("counter", value);
    }

    /**
     * Set increment
     *
     * @param value value of "increment" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("increment")
    public SecureSetCounterQueryWithArray increment(Boolean value) {
        return unsafeParam("increment", value);
    }

    /**
     * counters
     * Set counters
     *
     * @param value value of "counters" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("counters")
    public SecureSetCounterQueryWithArray counters(String... value) {
        return unsafeParam("counters", value);
    }

    /**
     * Set counters
     *
     * @param value value of "counters" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("counters")
    public SecureSetCounterQueryWithArray counters(List<String> value) {
        return unsafeParam("counters", value);
    }

    @Override
    protected SecureSetCounterQueryWithArray getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
