// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.streaming;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.streaming.GetStatsInterval;
import com.vk.api.sdk.objects.streaming.GetStatsType;
import com.vk.api.sdk.objects.streaming.responses.GetStatsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Streaming.getStats method
 */
public class StreamingGetStatsQuery extends AbstractQueryBuilder<StreamingGetStatsQuery, List<GetStatsResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public StreamingGetStatsQuery(VkApiClient client, ServiceActor actor) {
        super(client, "streaming.getStats", Utils.buildParametrizedType(List.class, GetStatsResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set type
     *
     * @param value value of "type" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("type")
    public StreamingGetStatsQuery type(GetStatsType value) {
        return unsafeParam("type", value);
    }

    /**
     * Set interval
     *
     * @param value value of "interval" parameter. By default 5m.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("interval")
    public StreamingGetStatsQuery interval(GetStatsInterval value) {
        return unsafeParam("interval", value);
    }

    /**
     * Set start time
     *
     * @param value value of "start time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("start_time")
    public StreamingGetStatsQuery startTime(Long value) {
        return unsafeParam("start_time", value);
    }

    /**
     * Set end time
     *
     * @param value value of "end time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("end_time")
    public StreamingGetStatsQuery endTime(Long value) {
        return unsafeParam("end_time", value);
    }

    @Override
    protected StreamingGetStatsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
