// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.translations;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.translations.responses.TranslateResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Translations.translate method
 */
public class TranslationsTranslateQuery extends AbstractQueryBuilder<TranslationsTranslateQuery, TranslateResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param translationLanguage value of "translation language" parameter.
     * @param texts value of "texts" parameter.
     */
    public TranslationsTranslateQuery(VkApiClient client, UserActor actor,
            String translationLanguage, String... texts) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
        translationLanguage(translationLanguage);
        texts(texts);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param translationLanguage value of "translation language" parameter.
     * @param texts value of "texts" parameter.
     */
    public TranslationsTranslateQuery(VkApiClient client, UserActor actor,
            String translationLanguage, List<String> texts) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
        translationLanguage(translationLanguage);
        texts(texts);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public TranslationsTranslateQuery(VkApiClient client, UserActor actor) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param translationLanguage value of "translation language" parameter.
     * @param texts value of "texts" parameter.
     */
    public TranslationsTranslateQuery(VkApiClient client, ServiceActor actor,
            String translationLanguage, String... texts) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        translationLanguage(translationLanguage);
        texts(texts);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param translationLanguage value of "translation language" parameter.
     * @param texts value of "texts" parameter.
     */
    public TranslationsTranslateQuery(VkApiClient client, ServiceActor actor,
            String translationLanguage, List<String> texts) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        translationLanguage(translationLanguage);
        texts(texts);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public TranslationsTranslateQuery(VkApiClient client, ServiceActor actor) {
        super(client, "translations.translate", TranslateResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * Set translation language
     *
     * @param value value of "translation language" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("translation_language")
    public TranslationsTranslateQuery translationLanguage(String value) {
        return unsafeParam("translation_language", value);
    }

    /**
     * texts
     * Set texts
     *
     * @param value value of "texts" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("texts")
    public TranslationsTranslateQuery texts(String... value) {
        return unsafeParam("texts", value);
    }

    /**
     * Set texts
     *
     * @param value value of "texts" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("texts")
    public TranslationsTranslateQuery texts(List<String> value) {
        return unsafeParam("texts", value);
    }

    @Override
    protected TranslationsTranslateQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("texts", "translation_language", "access_token");
    }
}
