// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.video;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Video.reorderAlbums method
 */
public class VideoReorderAlbumsQuery extends AbstractQueryBuilder<VideoReorderAlbumsQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param albumId value of "album id" parameter. Minimum is 0.
     */
    public VideoReorderAlbumsQuery(VkApiClient client, UserActor actor, Integer albumId) {
        super(client, "video.reorderAlbums", OkResponse.class);
        accessToken(actor.getAccessToken());
        albumId(albumId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public VideoReorderAlbumsQuery(VkApiClient client, UserActor actor) {
        super(client, "video.reorderAlbums", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the user or community that owns the albums..
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public VideoReorderAlbumsQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Album ID.
     *
     * @param value value of "album id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("album_id")
    public VideoReorderAlbumsQuery albumId(Integer value) {
        return unsafeParam("album_id", value);
    }

    /**
     * ID of the album before which the album in question shall be placed.
     *
     * @param value value of "before" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("before")
    public VideoReorderAlbumsQuery before(Integer value) {
        return unsafeParam("before", value);
    }

    /**
     * ID of the album after which the album in question shall be placed.
     *
     * @param value value of "after" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("after")
    public VideoReorderAlbumsQuery after(Integer value) {
        return unsafeParam("after", value);
    }

    @Override
    protected VideoReorderAlbumsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("album_id", "access_token");
    }
}
