// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.video;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.video.responses.StartStreamingResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Video.startStreaming method
 */
public class VideoStartStreamingQuery extends AbstractQueryBuilder<VideoStartStreamingQuery, StartStreamingResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public VideoStartStreamingQuery(VkApiClient client, UserActor actor) {
        super(client, "video.startStreaming", StartStreamingResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set video id
     *
     * @param value value of "video id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_id")
    public VideoStartStreamingQuery videoId(Integer value) {
        return unsafeParam("video_id", value);
    }

    /**
     * Set name
     *
     * @param value value of "name" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("name")
    public VideoStartStreamingQuery name(String value) {
        return unsafeParam("name", value);
    }

    /**
     * Set description
     *
     * @param value value of "description" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("description")
    public VideoStartStreamingQuery description(String value) {
        return unsafeParam("description", value);
    }

    /**
     * Set wallpost
     *
     * @param value value of "wallpost" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wallpost")
    public VideoStartStreamingQuery wallpost(Boolean value) {
        return unsafeParam("wallpost", value);
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public VideoStartStreamingQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set no comments
     *
     * @param value value of "no comments" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("no_comments")
    public VideoStartStreamingQuery noComments(Boolean value) {
        return unsafeParam("no_comments", value);
    }

    /**
     * Set category id
     *
     * @param value value of "category id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("category_id")
    public VideoStartStreamingQuery categoryId(Integer value) {
        return unsafeParam("category_id", value);
    }

    /**
     * Set publish
     *
     * @param value value of "publish" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("publish")
    public VideoStartStreamingQuery publish(Boolean value) {
        return unsafeParam("publish", value);
    }

    /**
     * privacyView
     * Set privacy view
     *
     * @param value value of "privacy view" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_view")
    public VideoStartStreamingQuery privacyView(String... value) {
        return unsafeParam("privacy_view", value);
    }

    /**
     * Set privacy view
     *
     * @param value value of "privacy view" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_view")
    public VideoStartStreamingQuery privacyView(List<String> value) {
        return unsafeParam("privacy_view", value);
    }

    /**
     * privacyComment
     * Set privacy comment
     *
     * @param value value of "privacy comment" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_comment")
    public VideoStartStreamingQuery privacyComment(String... value) {
        return unsafeParam("privacy_comment", value);
    }

    /**
     * Set privacy comment
     *
     * @param value value of "privacy comment" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("privacy_comment")
    public VideoStartStreamingQuery privacyComment(List<String> value) {
        return unsafeParam("privacy_comment", value);
    }

    @Override
    protected VideoStartStreamingQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
