// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.wall;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.wall.responses.RepostResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Wall.repost method
 */
public class WallRepostQuery extends AbstractQueryBuilder<WallRepostQuery, RepostResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param object value of "object" parameter.
     */
    public WallRepostQuery(VkApiClient client, UserActor actor, String object) {
        super(client, "wall.repost", RepostResponse.class);
        accessToken(actor.getAccessToken());
        object(object);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public WallRepostQuery(VkApiClient client, UserActor actor) {
        super(client, "wall.repost", RepostResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the object to be reposted on the wall. Example: "wall66748_3675"
     *
     * @param value value of "object" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("object")
    public WallRepostQuery object(String value) {
        return unsafeParam("object", value);
    }

    /**
     * Comment to be added along with the reposted object.
     *
     * @param value value of "message" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message")
    public WallRepostQuery message(String value) {
        return unsafeParam("message", value);
    }

    /**
     * Target community ID when reposting to a community.
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public WallRepostQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set mark as ads
     *
     * @param value value of "mark as ads" parameter. By default false.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("mark_as_ads")
    public WallRepostQuery markAsAds(Boolean value) {
        return unsafeParam("mark_as_ads", value);
    }

    /**
     * Set mute notifications
     *
     * @param value value of "mute notifications" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("mute_notifications")
    public WallRepostQuery muteNotifications(Boolean value) {
        return unsafeParam("mute_notifications", value);
    }

    @Override
    protected WallRepostQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("object", "access_token");
    }
}
