/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.ClientResponseTypeable;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ApiExtendedException;
import com.vk.api.sdk.exceptions.ApiServerException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.exceptions.ExceptionMapper;
import com.vk.api.sdk.exceptions.RequiredFieldException;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.base.Error;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiRequest.class);
    private TransportClient client;
    private Gson gson;
    private String url;
    private Type responseClass;
    private int retryAttempts;
    private List<Header> headers = new ArrayList<Header>();
    private Map<String, String> cookies = new HashMap<String, String>();

    public ApiRequest(String url, TransportClient client, Gson gson, int retryAttempts, Type responseClass) {
        this.client = client;
        this.url = url;
        this.responseClass = responseClass;
        this.gson = gson;
        this.retryAttempts = retryAttempts;
    }

    public ApiRequest<T> setCookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public ApiRequest<T> setCookies(Map<String, String> entries) {
        this.cookies.putAll(entries);
        return this;
    }

    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    private Header getCookies() {
        return new BasicHeader("Cookie", this.cookies.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).reduce("", (result, cookie) -> result + cookie + ";"));
    }

    public ApiRequest<T> setHeaders(Header[] headers) {
        if (headers != null) {
            this.headers = Arrays.asList(headers);
        }
        return this;
    }

    public ApiRequest<T> addHeader(Header header) {
        if (header != null) {
            this.headers.add(header);
        }
        return this;
    }

    public ApiRequest<T> addHeaders(List<Header> headers) {
        if (headers != null && !headers.isEmpty()) {
            this.headers.addAll(headers);
        }
        return this;
    }

    public ApiRequest<T> setHeaders(List<Header> headers) {
        if (headers != null) {
            this.headers = new ArrayList<Header>(headers);
        }
        return this;
    }

    public Header[] getHeaders() {
        ArrayList<Header> result = new ArrayList<Header>(this.headers);
        result.addAll(Arrays.asList(this.getQueryHeaders()));
        if (!this.cookies.isEmpty()) {
            result.add(this.getCookies());
        }
        return result.toArray(new Header[0]);
    }

    public String getUrl() {
        return this.url;
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected TransportClient getClient() {
        return this.client;
    }

    public Type getResponseClass() {
        return this.responseClass;
    }

    public T execute() throws ApiException, ClientException {
        ApiServerException exception = null;
        for (int i = 0; i < this.retryAttempts; ++i) {
            try {
                return this.executeWithoutRetry();
            }
            catch (ApiServerException e) {
                LOG.warn("API Server error", (Throwable)e);
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public ClientResponseTypeable<T> executeTypeable() throws ApiExtendedException, ClientException {
        ApiExtendedException exception = null;
        for (int i = 0; i < this.retryAttempts; ++i) {
            try {
                return this.executeTypeableWithoutRetry();
            }
            catch (ApiExtendedException e) {
                LOG.warn("API Server error", (Throwable)e);
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public T executeWithoutRetry() throws ClientException, ApiException {
        return this.parseClientResponse(this.executeAsStringWithReturningFullInfo());
    }

    public ClientResponseTypeable<T> executeTypeableWithoutRetry() throws ClientException, ApiExtendedException {
        ClientResponse response = this.executeAsStringWithReturningFullInfo();
        return new ClientResponseTypeable<T>(response.getStatusCode(), this.parseClientResponse(response), response.getHeaders());
    }

    private T parseClientResponse(ClientResponse clientResponse) throws ClientException, ApiExtendedException {
        String textResponse = (String)clientResponse.getContent();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(textResponse));
        JsonObject json = (JsonObject)new JsonParser().parse(jsonReader);
        if (json.has("error")) {
            Error error;
            JsonElement errorElement = json.get("error");
            try {
                error = (Error)this.gson.fromJson(errorElement, Error.class);
            }
            catch (JsonSyntaxException e) {
                LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
                throw new ClientException("Can't parse json response");
            }
            ApiException apiException = ExceptionMapper.parseException(error);
            ApiExtendedException extendedException = new ApiExtendedException(apiException.getCode(), clientResponse.getStatusCode(), clientResponse.getHeaders(), apiException.getDescription(), apiException.getMessageRaw());
            LOG.error("API error", (Throwable)extendedException);
            throw extendedException;
        }
        JsonObject response = json;
        if (json.has("response")) {
            response = json.get("response");
        }
        try {
            Object result = this.gson.fromJson((JsonElement)response, this.responseClass);
            if (result instanceof Validable) {
                try {
                    Validable validable = (Validable)result;
                    validable.validateRequired();
                }
                catch (RequiredFieldException e) {
                    throw new ClientException("JSON validate fail: " + textResponse + "\n" + e.toString());
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                    throw new ClientException("JSON validate fail:" + textResponse + e.toString());
                }
            }
            return (T)result;
        }
        catch (JsonSyntaxException e) {
            throw new ClientException("Can't parse json response: " + textResponse + "\n" + e.toString());
        }
    }

    public ClientResponse executeAsStringWithReturningFullInfo() throws ClientException {
        ClientResponse response;
        try {
            response = this.client.post(this.url, this.getBody(), this.getHeaders());
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.url, (Throwable)e);
            throw new ClientException("I/O exception");
        }
        if (response.getStatusCode() != 200) {
            throw new ClientException("Internal API server error. Wrong status code: " + response.getStatusCode() + ". Content: " + (String)response.getContent());
        }
        Map<String, String> headers = response.getHeaders();
        if (!headers.containsKey("Content-Type")) {
            throw new ClientException("No content type header");
        }
        String contentType = headers.get("Content-Type");
        if (!contentType.contains("application/json") && !contentType.contains("text/javascript")) {
            throw new ClientException("Invalid content type");
        }
        return response;
    }

    public String executeAsString() throws ClientException {
        return (String)this.executeAsStringWithReturningFullInfo().getContent();
    }

    public ClientResponse executeAsRaw() throws ClientException {
        try {
            return this.client.post(this.url, this.getBody(), this.getHeaders());
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.url, (Throwable)e);
            throw new ClientException("I/O exception");
        }
    }

    protected abstract String getBody();

    protected abstract Header[] getQueryHeaders();
}

