/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.queries.upload;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.vk.api.sdk.client.ApiRequest;
import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.ClientResponseTypeable;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ApiExtendedException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.exceptions.UploadException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadQueryBuilder<T, R>
extends ApiRequest<R> {
    private static final Logger LOG = LoggerFactory.getLogger(UploadQueryBuilder.class);
    private final List<Header> headers = new ArrayList<Header>();
    private final Map<String, File> files;

    public UploadQueryBuilder(VkApiClient client, String uploadUrl, Map<String, File> files, Type type) {
        super(uploadUrl, client.getTransportClient(), client.getGson(), 0, type);
        this.files = files;
    }

    protected abstract T getThis();

    @Override
    public R execute() throws ApiException, ClientException {
        return this.parseClientResponse(this.executeAsStringWithReturningFullInfo());
    }

    @Override
    public ClientResponseTypeable<R> executeTypeable() throws ApiExtendedException, ClientException {
        ClientResponse response = this.executeAsStringWithReturningFullInfo();
        return new ClientResponseTypeable<R>(response.getStatusCode(), this.parseClientResponse(response), response.getHeaders());
    }

    private R parseClientResponse(ClientResponse response) throws ClientException, ApiExtendedException {
        String textResponse = (String)response.getContent();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(textResponse));
        JsonObject json = (JsonObject)JsonParser.parseReader((JsonReader)jsonReader);
        if (json.has("error")) {
            UploadException uploadException = new UploadException(0, response.getStatusCode(), response.getHeaders(), textResponse, "");
            LOG.error("API error", (Throwable)uploadException);
            throw uploadException;
        }
        JsonObject json_response = json.has("response") ? json.get("response") : json;
        try {
            return (R)this.getGson().fromJson((JsonElement)json_response, this.getResponseClass());
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
            throw new ClientException("Can't parse json response");
        }
    }

    @Override
    public ClientResponse executeAsStringWithReturningFullInfo() throws ClientException {
        ClientResponse response;
        try {
            response = this.files != null ? this.getClient().post(this.getUrl(), this.files) : this.getClient().post(this.getUrl());
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.getUrl(), (Throwable)e);
            throw new ClientException("I/O exception");
        }
        if (response.getStatusCode() != 200) {
            LOG.error("Invalid HTTP status " + response.getStatusCode() + " from " + this.getUrl());
            throw new ClientException("Internal API server error");
        }
        return response;
    }

    @Override
    public String executeAsString() throws ClientException {
        return (String)this.executeAsStringWithReturningFullInfo().getContent();
    }

    @Override
    protected String getBody() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    protected Header[] getQueryHeaders() {
        ArrayList<Header> result = new ArrayList<Header>(this.headers);
        return result.toArray(new Header[0]);
    }

    public T withHeader(BasicHeader header) {
        this.headers.add((Header)header);
        return this.getThis();
    }

    public T withHeaders(List<BasicHeader> list) {
        this.headers.addAll(list);
        return this.getThis();
    }
}

