/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vk.api.sdk.deserializers.GsonDeserializer;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class ClientResponseTypeable<T> {
    private int statusCode;
    private T content;
    private Map<String, String> headers;

    public ClientResponseTypeable(int statusCode, T content, Map<String, String> headers) {
        this.statusCode = statusCode;
        this.content = content;
        this.headers = headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public T getContent() {
        return this.content;
    }

    public JsonElement getJson() {
        return (JsonElement)GsonDeserializer.deserialize(new Gson().toJson(this.content), JsonElement.class);
    }

    public JsonObject getJsonObject() {
        return (JsonObject)GsonDeserializer.deserialize(new Gson().toJson(this.content), JsonObject.class);
    }

    public JsonArray getJsonArray() {
        return (JsonArray)GsonDeserializer.deserialize(new Gson().toJson(this.content), JsonArray.class);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCookie(String header, String cookie) {
        return Arrays.stream(this.getHeaders().get(header).split(";")).filter(entry -> entry.contains(cookie)).map(entry -> entry.split("=")[1]).findFirst().orElse(null);
    }

    public Map<String, String> getCookies(String header) {
        return Arrays.stream(this.getHeaders().get(header).split(";")).map(entry -> entry.split("=")).collect(Collectors.toMap(cookieArr -> cookieArr[0], cookieArr -> cookieArr[1]));
    }

    public Map<String, String> getCookies() {
        return this.getCookies("Cookie");
    }
}

