/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.vk.api.sdk.objects.GroupAuthResponse;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class GroupAuthResponseDeserializer
implements JsonDeserializer {
    private static final String ACCESS_TOKEN_PREFIX = "access_token_";

    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("invalid json");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        HashMap<Integer, String> accessTokens = new HashMap<Integer, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (!((String)entry.getKey()).startsWith(ACCESS_TOKEN_PREFIX)) continue;
            Integer groupId = Integer.parseInt(((String)entry.getKey()).substring(ACCESS_TOKEN_PREFIX.length()));
            accessTokens.put(groupId, ((JsonElement)entry.getValue()).getAsString());
        }
        String error = null;
        if (jsonObject.has("error")) {
            error = jsonObject.get("error").getAsString();
        }
        return new GroupAuthResponse(accessTokens, jsonObject.get("expires_in").getAsInt(), error);
    }
}

