/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.events;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.vk.api.sdk.client.GsonHolder;
import com.vk.api.sdk.exceptions.UnexpectedOneOfSubtypeException;
import com.vk.api.sdk.objects.callback.AudioNew;
import com.vk.api.sdk.objects.callback.BoardPostDelete;
import com.vk.api.sdk.objects.callback.BoardPostEdit;
import com.vk.api.sdk.objects.callback.BoardPostNew;
import com.vk.api.sdk.objects.callback.BoardPostRestore;
import com.vk.api.sdk.objects.callback.Confirmation;
import com.vk.api.sdk.objects.callback.GroupChangePhoto;
import com.vk.api.sdk.objects.callback.GroupChangeSettings;
import com.vk.api.sdk.objects.callback.GroupJoin;
import com.vk.api.sdk.objects.callback.GroupLeave;
import com.vk.api.sdk.objects.callback.GroupOfficersEdit;
import com.vk.api.sdk.objects.callback.MarketComment;
import com.vk.api.sdk.objects.callback.MarketCommentDelete;
import com.vk.api.sdk.objects.callback.MessageAllow;
import com.vk.api.sdk.objects.callback.MessageDeny;
import com.vk.api.sdk.objects.callback.MessageEdit;
import com.vk.api.sdk.objects.callback.MessageNew;
import com.vk.api.sdk.objects.callback.MessageReply;
import com.vk.api.sdk.objects.callback.PhotoComment;
import com.vk.api.sdk.objects.callback.PhotoCommentDelete;
import com.vk.api.sdk.objects.callback.PhotoNew;
import com.vk.api.sdk.objects.callback.PollVoteNew;
import com.vk.api.sdk.objects.callback.UserBlock;
import com.vk.api.sdk.objects.callback.UserUnblock;
import com.vk.api.sdk.objects.callback.VideoComment;
import com.vk.api.sdk.objects.callback.VideoCommentDelete;
import com.vk.api.sdk.objects.callback.VideoNew;
import com.vk.api.sdk.objects.callback.WallCommentDelete;
import com.vk.api.sdk.objects.callback.WallPostNew;
import com.vk.api.sdk.objects.callback.WallReplyEdit;
import com.vk.api.sdk.objects.callback.WallReplyNew;
import com.vk.api.sdk.objects.callback.WallReplyRestore;
import com.vk.api.sdk.objects.callback.WallRepost;
import com.vk.api.sdk.objects.callback.messages.CallbackMessage;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CallbackEvent {
    public static final String OVERRIDING_ERR = "Method of handling event is not overridden";
    public static final Logger LOG = LoggerFactory.getLogger(CallbackEvent.class);
    public static final Gson GSON = new GsonHolder().getGson();

    default public MessageNew getCallbackEventAsMessageNew() {
        return (MessageNew)this;
    }

    default public MessageReply getCallbackEventAsMessageReply() {
        return (MessageReply)this;
    }

    default public MessageAllow getCallbackEventAsMessageAllow() {
        return (MessageAllow)this;
    }

    default public MessageEdit getCallbackEventAsMessageEdit() {
        return (MessageEdit)this;
    }

    default public PhotoNew getCallbackEventAsPhotoNew() {
        return (PhotoNew)this;
    }

    default public PhotoComment getCallbackEventAsPhotoCommentNew() {
        return (PhotoComment)this;
    }

    default public PhotoComment getCallbackEventAsPhotoCommentEdit() {
        return (PhotoComment)this;
    }

    default public PhotoComment getCallbackEventAsPhotoCommentRestore() {
        return (PhotoComment)this;
    }

    default public PhotoCommentDelete getCallbackEventAsPhotoCommentDelete() {
        return (PhotoCommentDelete)this;
    }

    default public AudioNew getCallbackEventAsAudioNew() {
        return (AudioNew)this;
    }

    default public VideoNew getCallbackEventAsVideoNew() {
        return (VideoNew)this;
    }

    default public VideoComment getCallbackEventAsVideoCommentNew() {
        return (VideoComment)this;
    }

    default public VideoComment getCallbackEventAsVideoCommentEdit() {
        return (VideoComment)this;
    }

    default public VideoComment getCallbackEventAsVideoCommentRestore() {
        return (VideoComment)this;
    }

    default public VideoCommentDelete getCallbackEventAsVideoCommentDelete() {
        return (VideoCommentDelete)this;
    }

    default public WallPostNew getCallbackEventAsWallPostNew() {
        return (WallPostNew)this;
    }

    default public WallRepost getCallbackEventAsWallRepost() {
        return (WallRepost)this;
    }

    default public WallReplyNew getCallbackEventAsWallReplyNew() {
        return (WallReplyNew)this;
    }

    default public WallReplyEdit getCallbackEventAsWallReplyEdit() {
        return (WallReplyEdit)this;
    }

    default public WallReplyRestore getCallbackEventAsWallReplyRestore() {
        return (WallReplyRestore)this;
    }

    default public WallCommentDelete getCallbackEventAsWallReplyDelete() {
        return (WallCommentDelete)this;
    }

    default public BoardPostNew getCallbackEventAsBoardPostNew() {
        return (BoardPostNew)this;
    }

    default public BoardPostEdit getCallbackEventAsBoardPostEdit() {
        return (BoardPostEdit)this;
    }

    default public BoardPostRestore getCallbackEventAsBoardPostRestore() {
        return (BoardPostRestore)this;
    }

    default public BoardPostDelete getCallbackEventAsBoardPostDelete() {
        return (BoardPostDelete)this;
    }

    default public GroupLeave getCallbackEventAsGroupLeave() {
        return (GroupLeave)this;
    }

    default public GroupJoin getCallbackEventAsGroupJoin() {
        return (GroupJoin)this;
    }

    default public GroupChangeSettings getCallbackEventAsGroupChangeSettings() {
        return (GroupChangeSettings)this;
    }

    default public GroupChangePhoto getCallbackEventAsGroupChangePhoto() {
        return (GroupChangePhoto)this;
    }

    default public GroupOfficersEdit getCallbackEventAsGroupOfficersEdit() {
        return (GroupOfficersEdit)this;
    }

    default public PollVoteNew getCallbackEventAsPollVoteNew() {
        return (PollVoteNew)this;
    }

    default public UserBlock getCallbackEventAsUserBlock() {
        return (UserBlock)this;
    }

    default public UserUnblock getCallbackEventAsUserUnblock() {
        return (UserUnblock)this;
    }

    default public Confirmation getCallbackEventAsConfirmation() {
        return (Confirmation)this;
    }

    default public void messageNew(Integer groupId, MessageNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void messageReply(Integer groupId, MessageReply message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void messageEdit(Integer groupId, MessageEdit message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void messageAllow(Integer groupId, MessageAllow message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void messageDeny(Integer groupId, MessageDeny message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void photoNew(Integer groupId, PhotoNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void photoCommentNew(Integer groupId, PhotoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void photoCommentEdit(Integer groupId, PhotoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void photoCommentRestore(Integer groupId, PhotoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void photoCommentDelete(Integer groupId, PhotoCommentDelete message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void audioNew(Integer groupId, AudioNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void videoNew(Integer groupId, VideoNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void videoCommentNew(Integer groupId, VideoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void videoCommentEdit(Integer groupId, VideoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void videoCommentRestore(Integer groupId, VideoComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void videoCommentDelete(Integer groupId, VideoCommentDelete message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallPostNew(Integer groupId, WallPostNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallRepost(Integer groupId, WallRepost message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallReplyNew(Integer groupId, WallReplyNew object) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallReplyEdit(Integer groupId, WallReplyEdit message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallReplyRestore(Integer groupId, WallReplyRestore message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void wallReplyDelete(Integer groupId, WallCommentDelete message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void boardPostNew(Integer groupId, BoardPostNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void boardPostEdit(Integer groupId, BoardPostEdit message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void boardPostRestore(Integer groupId, BoardPostRestore message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void boardPostDelete(Integer groupId, BoardPostDelete message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void marketCommentNew(Integer groupId, MarketComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void marketCommentEdit(Integer groupId, MarketComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void marketCommentRestore(Integer groupId, MarketComment message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void marketCommentDelete(Integer groupId, MarketCommentDelete message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void groupLeave(Integer groupId, GroupLeave message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void groupJoin(Integer groupId, GroupJoin message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void groupChangeSettings(Integer groupId, GroupChangeSettings message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void groupChangePhoto(Integer groupId, GroupChangePhoto message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void groupOfficersEdit(Integer groupId, GroupOfficersEdit message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void pollVoteNew(Integer groupId, PollVoteNew message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void userBlock(Integer groupId, UserBlock message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public void userUnblock(Integer groupId, UserUnblock message) {
        LOG.error(OVERRIDING_ERR);
    }

    default public String confirmation() {
        LOG.error(OVERRIDING_ERR);
        return null;
    }

    default public String parse(CallbackMessage message) {
        System.out.println("Received callback message type: " + (Object)((Object)message.getType()));
        System.out.println("Received callback message: " + message.getObject());
        String objectToDeserialize = message.getObject().toString();
        switch (message.getType()) {
            case MESSAGE_NEW: 
            case MESSAGE_DENY: 
            case MESSAGE_REPLY: 
            case MESSAGE_EDIT: 
            case MESSAGE_ALLOW: {
                objectToDeserialize = "{ \"object\": " + objectToDeserialize + "}";
            }
        }
        CallbackEvent event = (CallbackEvent)GSON.fromJson(objectToDeserialize, message.getType().getType());
        System.out.println("Deserialized event object: " + event.toString());
        switch (message.getType()) {
            case CONFIRMATION: {
                this.confirmation();
                return "OK";
            }
            case MESSAGE_NEW: {
                this.messageNew(message.getGroupId(), (MessageNew)event);
                return "OK";
            }
            case MESSAGE_REPLY: {
                this.messageReply(message.getGroupId(), (MessageReply)event);
                return "OK";
            }
            case MESSAGE_EDIT: {
                this.messageEdit(message.getGroupId(), (MessageEdit)event);
                return "OK";
            }
            case MESSAGE_ALLOW: {
                this.messageAllow(message.getGroupId(), (MessageAllow)event);
                return "OK";
            }
            case MESSAGE_DENY: {
                this.messageDeny(message.getGroupId(), (MessageDeny)event);
                return "OK";
            }
            case PHOTO_NEW: {
                this.photoNew(message.getGroupId(), (PhotoNew)event);
                return "OK";
            }
            case PHOTO_COMMENT_NEW: {
                this.photoCommentNew(message.getGroupId(), (PhotoComment)event);
                return "OK";
            }
            case PHOTO_COMMENT_EDIT: {
                this.photoCommentEdit(message.getGroupId(), (PhotoComment)event);
                return "OK";
            }
            case PHOTO_COMMENT_RESTORE: {
                this.photoCommentRestore(message.getGroupId(), (PhotoComment)event);
                return "OK";
            }
            case PHOTO_COMMENT_DELETE: {
                this.photoCommentDelete(message.getGroupId(), (PhotoCommentDelete)event);
                return "OK";
            }
            case AUDIO_NEW: {
                this.audioNew(message.getGroupId(), (AudioNew)event);
                return "OK";
            }
            case VIDEO_NEW: {
                this.videoNew(message.getGroupId(), (VideoNew)event);
                return "OK";
            }
            case VIDEO_COMMENT_NEW: {
                this.videoCommentNew(message.getGroupId(), (VideoComment)event);
                return "OK";
            }
            case VIDEO_COMMENT_EDIT: {
                this.videoCommentEdit(message.getGroupId(), (VideoComment)event);
                return "OK";
            }
            case VIDEO_COMMENT_RESTORE: {
                this.videoCommentRestore(message.getGroupId(), (VideoComment)event);
                return "OK";
            }
            case VIDEO_COMMENT_DELETE: {
                this.videoCommentDelete(message.getGroupId(), (VideoCommentDelete)event);
                return "OK";
            }
            case WALL_POST_NEW: {
                this.wallPostNew(message.getGroupId(), (WallPostNew)event);
                return "OK";
            }
            case WALL_REPOST: {
                this.wallRepost(message.getGroupId(), (WallRepost)event);
                return "OK";
            }
            case WALL_REPLY_NEW: {
                this.wallReplyNew(message.getGroupId(), (WallReplyNew)event);
                return "OK";
            }
            case WALL_REPLY_EDIT: {
                this.wallReplyEdit(message.getGroupId(), (WallReplyEdit)event);
                return "OK";
            }
            case WALL_REPLY_RESTORE: {
                this.wallReplyRestore(message.getGroupId(), (WallReplyRestore)event);
                return "OK";
            }
            case WALL_REPLY_DELETE: {
                this.wallReplyDelete(message.getGroupId(), (WallCommentDelete)event);
                return "OK";
            }
            case BOARD_POST_NEW: {
                this.boardPostNew(message.getGroupId(), (BoardPostNew)event);
                return "OK";
            }
            case BOARD_POST_EDIT: {
                this.boardPostEdit(message.getGroupId(), (BoardPostEdit)event);
                return "OK";
            }
            case BOARD_POST_RESTORE: {
                this.boardPostRestore(message.getGroupId(), (BoardPostRestore)event);
                return "OK";
            }
            case BOARD_POST_DELETE: {
                this.boardPostDelete(message.getGroupId(), (BoardPostDelete)event);
                return "OK";
            }
            case MARKET_COMMENT_NEW: {
                this.marketCommentNew(message.getGroupId(), (MarketComment)event);
                return "OK";
            }
            case MARKET_COMMENT_EDIT: {
                this.marketCommentEdit(message.getGroupId(), (MarketComment)event);
                return "OK";
            }
            case MARKET_COMMENT_RESTORE: {
                this.marketCommentRestore(message.getGroupId(), (MarketComment)event);
                return "OK";
            }
            case MARKET_COMMENT_DELETE: {
                this.marketCommentDelete(message.getGroupId(), (MarketCommentDelete)event);
                return "OK";
            }
            case GROUP_LEAVE: {
                this.groupLeave(message.getGroupId(), (GroupLeave)event);
                return "OK";
            }
            case GROUP_JOIN: {
                this.groupJoin(message.getGroupId(), (GroupJoin)event);
                return "OK";
            }
            case GROUP_CHANGE_SETTINGS: {
                this.groupChangeSettings(message.getGroupId(), (GroupChangeSettings)event);
                return "OK";
            }
            case GROUP_CHANGE_PHOTO: {
                this.groupChangePhoto(message.getGroupId(), (GroupChangePhoto)event);
                return "OK";
            }
            case GROUP_OFFICERS_EDIT: {
                this.groupOfficersEdit(message.getGroupId(), (GroupOfficersEdit)event);
                return "OK";
            }
            case USER_BLOCK: {
                this.userBlock(message.getGroupId(), (UserBlock)event);
                return "OK";
            }
            case USER_UNBLOCK: {
                this.userUnblock(message.getGroupId(), (UserUnblock)event);
                return "OK";
            }
            case POLL_VOTE_NEW: {
                this.pollVoteNew(message.getGroupId(), (PollVoteNew)event);
                return "OK";
            }
        }
        LOG.error("Unexpected callback event type received");
        return null;
    }

    public static class Deserializer
    implements JsonDeserializer<CallbackEvent> {
        private static final String discriminatorField = "type";
        private static final Map<String, Class<? extends CallbackEvent>> subtypes = new HashMap<String, Class<? extends CallbackEvent>>(){
            {
                this.put("message_new", MessageNew.class);
                this.put("message_reply", MessageReply.class);
                this.put("message_allow", MessageAllow.class);
                this.put("message_deny", MessageDeny.class);
                this.put("message_edit", MessageEdit.class);
                this.put("photo_new", PhotoNew.class);
                this.put("photo_comment_new", PhotoComment.class);
                this.put("photo_comment_edit", PhotoComment.class);
                this.put("photo_comment_restore", PhotoComment.class);
                this.put("photo_comment_delete", PhotoCommentDelete.class);
                this.put("audio_new", AudioNew.class);
                this.put("video_new", VideoNew.class);
                this.put("video_comment_new", VideoComment.class);
                this.put("video_comment_edit", VideoComment.class);
                this.put("video_comment_restore", VideoComment.class);
                this.put("video_comment_delete", VideoCommentDelete.class);
                this.put("wall_post_new", WallPostNew.class);
                this.put("wall_repost", WallRepost.class);
                this.put("wall_reply_new", WallReplyNew.class);
                this.put("wall_reply_edit", WallReplyEdit.class);
                this.put("wall_reply_restore", WallReplyRestore.class);
                this.put("wall_reply_delete", WallCommentDelete.class);
                this.put("board_post_new", BoardPostNew.class);
                this.put("board_post_edit", BoardPostEdit.class);
                this.put("board_post_restore", BoardPostRestore.class);
                this.put("board_post_delete", BoardPostDelete.class);
                this.put("market_comment_new", MarketComment.class);
                this.put("market_comment_edit", MarketComment.class);
                this.put("market_comment_restore", MarketComment.class);
                this.put("market_comment_delete", MarketCommentDelete.class);
                this.put("group_leave", GroupLeave.class);
                this.put("group_join", GroupJoin.class);
                this.put("group_change_settings", GroupChangeSettings.class);
                this.put("group_change_photo", GroupChangePhoto.class);
                this.put("group_officers_edit", GroupOfficersEdit.class);
                this.put("poll_vote_new", PollVoteNew.class);
                this.put("user_block", UserBlock.class);
                this.put("user_unblock", UserUnblock.class);
                this.put("confirmation", Confirmation.class);
            }
        };

        public CallbackEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject data = json.getAsJsonObject();
            String resultSubtypeValue = data.get(discriminatorField).getAsString();
            if (subtypes.containsKey(resultSubtypeValue)) {
                return (CallbackEvent)context.deserialize((JsonElement)data, (Type)subtypes.get(resultSubtypeValue));
            }
            throw new JsonParseException("There is no discriminator field in JSON-object", (Throwable)new UnexpectedOneOfSubtypeException(resultSubtypeValue, Deserializer.class, subtypes.keySet()));
        }
    }
}

