/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.events.longpoll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.vk.api.sdk.client.ApiRequest;
import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.ClientResponseTypeable;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ApiExtendedException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.exceptions.LongPollServerKeyExpiredException;
import com.vk.api.sdk.exceptions.LongPollServerTsException;
import com.vk.api.sdk.objects.base.Error;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongPollQueryBuilder<T, R>
extends ApiRequest<R> {
    private static final Logger LOG = LoggerFactory.getLogger(LongPollQueryBuilder.class);
    private static final Integer RETRY_ATTEMPTS = 3;
    private static final int INCORRECT_TS_VALUE_ERROR_CODE = 1;
    private static final int TOKEN_EXPIRED_ERROR_CODE = 2;
    private static final String FAILED_CODE = "failed";
    private final Map<String, String> params = new HashMap<String, String>();
    private final List<Header> headers = new ArrayList<Header>();

    public LongPollQueryBuilder(VkApiClient client, URI url, Type type) {
        super(url.toString(), client.getTransportClient(), RETRY_ATTEMPTS, type);
    }

    private static String escape(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected T key(String key) {
        return this.unsafeParam("key", key);
    }

    public T unsafeParam(String key, String value) {
        this.params.put(key, value);
        return this.getThis();
    }

    public T unsafeParam(String key, int value) {
        return this.unsafeParam(key, Integer.toString(value));
    }

    private static String mapToGetString(Map<String, String> params) {
        return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (entry.getValue() != null ? LongPollQueryBuilder.escape((String)entry.getValue()) : "")).collect(Collectors.joining("&"));
    }

    public T withHeader(BasicHeader header) {
        this.headers.add((Header)header);
        return this.getThis();
    }

    public T withHeaders(List<BasicHeader> list) {
        this.headers.addAll(list);
        return this.getThis();
    }

    @Override
    protected String getBody() {
        return LongPollQueryBuilder.mapToGetString(this.build());
    }

    @Override
    protected Header[] getQueryHeaders() {
        ArrayList<Header> result = new ArrayList<Header>(this.headers);
        return result.toArray(new Header[0]);
    }

    protected abstract T getThis();

    protected abstract Collection<String> essentialKeys();

    public Map<String, String> build() {
        if (!this.params.keySet().containsAll(this.essentialKeys())) {
            throw new IllegalArgumentException("Not all the keys are passed: essential keys are " + this.essentialKeys());
        }
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public R execute() throws ApiException, ClientException {
        return this.parseClientResponse(this.executeAsStringWithReturningFullInfo());
    }

    @Override
    public ClientResponseTypeable<R> executeTypeable() throws ApiExtendedException, ClientException {
        ClientResponse response = this.executeAsStringWithReturningFullInfo();
        return new ClientResponseTypeable<R>(response.getStatusCode(), this.parseClientResponse(response), response.getHeaders());
    }

    private R parseClientResponse(ClientResponse response) throws ClientException, ApiExtendedException {
        String textResponse = (String)response.getContent();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(textResponse));
        JsonObject json = (JsonObject)new JsonParser().parse(jsonReader);
        if (json.has(FAILED_CODE)) {
            JsonPrimitive failedParam = json.getAsJsonPrimitive(FAILED_CODE);
            int code = failedParam.getAsInt();
            Error error = new Error().setErrorCode(LongPollServerTsException.ERROR_CODE).setErrorText("Incorrect 'ts' value");
            switch (code) {
                case 1: {
                    int ts = json.getAsJsonPrimitive("ts").getAsInt();
                    error.setErrorMsg("\\'ts\\' value is incorrect, minimal value is 1, maximal value is " + ts);
                    throw new LongPollServerTsException(error, response.getStatusCode(), response.getHeaders());
                }
                case 2: {
                    error.setErrorMsg("Try to generate a new key.");
                    throw new LongPollServerKeyExpiredException(error, response.getStatusCode(), response.getHeaders());
                }
            }
            throw new ClientException("Unknown LongPollServer exception, something went wrong.");
        }
        try {
            return (R)this.getGson().fromJson((JsonElement)json, this.getResponseClass());
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
            throw new ClientException("Can't parse json response");
        }
    }
}

