/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.market.MarketCategory;
import com.vk.api.sdk.objects.market.MarketItemAvailability;
import com.vk.api.sdk.objects.market.Price;
import java.net.URI;
import java.util.Objects;

public class MarketItem
implements Validable {
    @SerializedName(value="access_key")
    private String accessKey;
    @SerializedName(value="availability")
    @Required
    private MarketItemAvailability availability;
    @SerializedName(value="button_title")
    private String buttonTitle;
    @SerializedName(value="category")
    @Required
    private MarketCategory category;
    @SerializedName(value="category_v2")
    private MarketCategory categoryV2;
    @SerializedName(value="date")
    private Integer date;
    @SerializedName(value="description")
    @Required
    private String description;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="id")
    @Required
    private Integer id;
    @SerializedName(value="is_adult")
    private Boolean isAdult;
    @SerializedName(value="is_favorite")
    private Boolean isFavorite;
    @SerializedName(value="is_main_variant")
    private Boolean isMainVariant;
    @SerializedName(value="is_owner")
    private Boolean isOwner;
    @SerializedName(value="owner_id")
    @Required
    private Long ownerId;
    @SerializedName(value="post_id")
    private Integer postId;
    @SerializedName(value="post_owner_id")
    private Long postOwnerId;
    @SerializedName(value="price")
    @Required
    private Price price;
    @SerializedName(value="sku")
    private String sku;
    @SerializedName(value="stock_amount")
    private Integer stockAmount;
    @SerializedName(value="thumb_photo")
    private URI thumbPhoto;
    @SerializedName(value="title")
    @Required
    private String title;
    @SerializedName(value="url")
    private String url;
    @SerializedName(value="variants_grouping_id")
    private Integer variantsGroupingId;

    public String getAccessKey() {
        return this.accessKey;
    }

    public MarketItem setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public MarketItemAvailability getAvailability() {
        return this.availability;
    }

    public MarketItem setAvailability(MarketItemAvailability availability) {
        this.availability = availability;
        return this;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public MarketItem setButtonTitle(String buttonTitle) {
        this.buttonTitle = buttonTitle;
        return this;
    }

    public MarketCategory getCategory() {
        return this.category;
    }

    public MarketItem setCategory(MarketCategory category) {
        this.category = category;
        return this;
    }

    public MarketCategory getCategoryV2() {
        return this.categoryV2;
    }

    public MarketItem setCategoryV2(MarketCategory categoryV2) {
        this.categoryV2 = categoryV2;
        return this;
    }

    public Integer getDate() {
        return this.date;
    }

    public MarketItem setDate(Integer date) {
        this.date = date;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MarketItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public MarketItem setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public Integer getId() {
        return this.id;
    }

    public MarketItem setId(Integer id) {
        this.id = id;
        return this;
    }

    public Boolean getIsAdult() {
        return this.isAdult;
    }

    public MarketItem setIsAdult(Boolean isAdult) {
        this.isAdult = isAdult;
        return this;
    }

    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    public MarketItem setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    public Boolean getIsMainVariant() {
        return this.isMainVariant;
    }

    public MarketItem setIsMainVariant(Boolean isMainVariant) {
        this.isMainVariant = isMainVariant;
        return this;
    }

    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public MarketItem setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public MarketItem setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Integer getPostId() {
        return this.postId;
    }

    public MarketItem setPostId(Integer postId) {
        this.postId = postId;
        return this;
    }

    public Long getPostOwnerId() {
        return this.postOwnerId;
    }

    public MarketItem setPostOwnerId(Long postOwnerId) {
        this.postOwnerId = postOwnerId;
        return this;
    }

    public Price getPrice() {
        return this.price;
    }

    public MarketItem setPrice(Price price) {
        this.price = price;
        return this;
    }

    public String getSku() {
        return this.sku;
    }

    public MarketItem setSku(String sku) {
        this.sku = sku;
        return this;
    }

    public Integer getStockAmount() {
        return this.stockAmount;
    }

    public MarketItem setStockAmount(Integer stockAmount) {
        this.stockAmount = stockAmount;
        return this;
    }

    public URI getThumbPhoto() {
        return this.thumbPhoto;
    }

    public MarketItem setThumbPhoto(URI thumbPhoto) {
        this.thumbPhoto = thumbPhoto;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public MarketItem setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public MarketItem setUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer getVariantsGroupingId() {
        return this.variantsGroupingId;
    }

    public MarketItem setVariantsGroupingId(Integer variantsGroupingId) {
        this.variantsGroupingId = variantsGroupingId;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.date, this.variantsGroupingId, this.thumbPhoto, this.buttonTitle, this.postOwnerId, this.description, this.externalId, this.availability, this.postId, this.ownerId, this.title, this.url, this.stockAmount, this.isMainVariant, this.isOwner, this.accessKey, this.price, this.id, this.category, this.sku, this.categoryV2, this.isAdult, this.isFavorite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketItem marketItem = (MarketItem)o;
        return Objects.equals(this.date, marketItem.date) && Objects.equals(this.isFavorite, marketItem.isFavorite) && Objects.equals(this.stockAmount, marketItem.stockAmount) && Objects.equals(this.postOwnerId, marketItem.postOwnerId) && Objects.equals(this.isOwner, marketItem.isOwner) && Objects.equals(this.ownerId, marketItem.ownerId) && Objects.equals(this.description, marketItem.description) && Objects.equals(this.externalId, marketItem.externalId) && Objects.equals(this.isMainVariant, marketItem.isMainVariant) && Objects.equals(this.availability, marketItem.availability) && Objects.equals(this.title, marketItem.title) && Objects.equals(this.url, marketItem.url) && Objects.equals(this.isAdult, marketItem.isAdult) && Objects.equals(this.thumbPhoto, marketItem.thumbPhoto) && Objects.equals(this.postId, marketItem.postId) && Objects.equals(this.variantsGroupingId, marketItem.variantsGroupingId) && Objects.equals(this.categoryV2, marketItem.categoryV2) && Objects.equals(this.price, marketItem.price) && Objects.equals(this.accessKey, marketItem.accessKey) && Objects.equals(this.buttonTitle, marketItem.buttonTitle) && Objects.equals(this.id, marketItem.id) && Objects.equals(this.category, marketItem.category) && Objects.equals(this.sku, marketItem.sku);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder("MarketItem{");
        sb.append("date=").append(this.date);
        sb.append(", isFavorite=").append(this.isFavorite);
        sb.append(", stockAmount=").append(this.stockAmount);
        sb.append(", postOwnerId=").append(this.postOwnerId);
        sb.append(", isOwner=").append(this.isOwner);
        sb.append(", ownerId=").append(this.ownerId);
        sb.append(", description='").append(this.description).append("'");
        sb.append(", externalId='").append(this.externalId).append("'");
        sb.append(", isMainVariant=").append(this.isMainVariant);
        sb.append(", availability=").append(this.availability);
        sb.append(", title='").append(this.title).append("'");
        sb.append(", url='").append(this.url).append("'");
        sb.append(", isAdult=").append(this.isAdult);
        sb.append(", thumbPhoto=").append(this.thumbPhoto);
        sb.append(", postId=").append(this.postId);
        sb.append(", variantsGroupingId=").append(this.variantsGroupingId);
        sb.append(", categoryV2=").append(this.categoryV2);
        sb.append(", price=").append(this.price);
        sb.append(", accessKey='").append(this.accessKey).append("'");
        sb.append(", buttonTitle='").append(this.buttonTitle).append("'");
        sb.append(", id=").append(this.id);
        sb.append(", category=").append(this.category);
        sb.append(", sku='").append(this.sku).append("'");
        sb.append('}');
        return sb.toString();
    }
}

