/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.objects.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.messages.ConversationMessageRequest;
import com.vk.api.sdk.objects.messages.ConversationPeer;
import com.vk.api.sdk.objects.messages.ConversationSpecialServiceType;
import com.vk.api.sdk.objects.messages.Keyboard;
import java.util.List;
import java.util.Objects;

public class Conversation
implements Validable {
    @SerializedName(value="peer")
    @Required
    private ConversationPeer peer;
    @SerializedName(value="last_message_id")
    private Integer lastMessageId;
    @SerializedName(value="in_read")
    private Integer inRead;
    @SerializedName(value="out_read")
    private Integer outRead;
    @SerializedName(value="unread_count")
    private Integer unreadCount;
    @SerializedName(value="important")
    private Boolean important;
    @SerializedName(value="unanswered")
    private Boolean unanswered;
    @SerializedName(value="special_service_type")
    private ConversationSpecialServiceType specialServiceType;
    @SerializedName(value="message_request")
    private ConversationMessageRequest messageRequest;
    @SerializedName(value="mentions")
    private List<Integer> mentions;
    @SerializedName(value="current_keyboard")
    private Keyboard currentKeyboard;

    public ConversationPeer getPeer() {
        return this.peer;
    }

    public Conversation setPeer(ConversationPeer peer) {
        this.peer = peer;
        return this;
    }

    public Integer getLastMessageId() {
        return this.lastMessageId;
    }

    public Conversation setLastMessageId(Integer lastMessageId) {
        this.lastMessageId = lastMessageId;
        return this;
    }

    public Integer getInRead() {
        return this.inRead;
    }

    public Conversation setInRead(Integer inRead) {
        this.inRead = inRead;
        return this;
    }

    public Integer getOutRead() {
        return this.outRead;
    }

    public Conversation setOutRead(Integer outRead) {
        this.outRead = outRead;
        return this;
    }

    public Integer getUnreadCount() {
        return this.unreadCount;
    }

    public Conversation setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    public Boolean getImportant() {
        return this.important;
    }

    public Conversation setImportant(Boolean important) {
        this.important = important;
        return this;
    }

    public Boolean getUnanswered() {
        return this.unanswered;
    }

    public Conversation setUnanswered(Boolean unanswered) {
        this.unanswered = unanswered;
        return this;
    }

    public ConversationSpecialServiceType getSpecialServiceType() {
        return this.specialServiceType;
    }

    public Conversation setSpecialServiceType(ConversationSpecialServiceType specialServiceType) {
        this.specialServiceType = specialServiceType;
        return this;
    }

    public ConversationMessageRequest getMessageRequest() {
        return this.messageRequest;
    }

    public Conversation setMessageRequest(ConversationMessageRequest messageRequest) {
        this.messageRequest = messageRequest;
        return this;
    }

    public List<Integer> getMentions() {
        return this.mentions;
    }

    public Conversation setMentions(List<Integer> mentions) {
        this.mentions = mentions;
        return this;
    }

    public Keyboard getCurrentKeyboard() {
        return this.currentKeyboard;
    }

    public Conversation setCurrentKeyboard(Keyboard currentKeyboard) {
        this.currentKeyboard = currentKeyboard;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.important, this.outRead, this.peer, this.unanswered, this.mentions, this.currentKeyboard, this.unreadCount, this.inRead, this.lastMessageId, this.messageRequest, this.specialServiceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation conversation = (Conversation)o;
        return Objects.equals(this.important, conversation.important) && Objects.equals(this.lastMessageId, conversation.lastMessageId) && Objects.equals(this.unreadCount, conversation.unreadCount) && Objects.equals(this.specialServiceType, conversation.specialServiceType) && Objects.equals(this.inRead, conversation.inRead) && Objects.equals(this.peer, conversation.peer) && Objects.equals(this.unanswered, conversation.unanswered) && Objects.equals(this.mentions, conversation.mentions) && Objects.equals(this.currentKeyboard, conversation.currentKeyboard) && Objects.equals(this.outRead, conversation.outRead) && Objects.equals(this.messageRequest, conversation.messageRequest);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder("Conversation{");
        sb.append("important=").append(this.important);
        sb.append(", lastMessageId=").append(this.lastMessageId);
        sb.append(", unreadCount=").append(this.unreadCount);
        sb.append(", specialServiceType='").append(this.specialServiceType).append("'");
        sb.append(", inRead=").append(this.inRead);
        sb.append(", peer=").append(this.peer);
        sb.append(", unanswered=").append(this.unanswered);
        sb.append(", mentions=").append(this.mentions);
        sb.append(", currentKeyboard=").append(this.currentKeyboard);
        sb.append(", outRead=").append(this.outRead);
        sb.append(", messageRequest='").append(this.messageRequest).append("'");
        sb.append('}');
        return sb.toString();
    }
}

