/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.streaming.clients;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.streaming.actions.StreamingRules;
import com.vk.api.sdk.streaming.actions.StreamingStream;
import java.io.Closeable;
import java.io.IOException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;

public class VkStreamingApiClient
implements Closeable {
    private Gson gson;
    private TransportClient transportClient;
    private AsyncHttpClient asyncHttpClient;

    public VkStreamingApiClient(TransportClient transportClient) {
        this(transportClient, new GsonBuilder().create());
    }

    public VkStreamingApiClient(TransportClient transportClient, Gson gson) {
        this.transportClient = transportClient;
        this.gson = gson;
        this.asyncHttpClient = new DefaultAsyncHttpClient();
    }

    public Gson getGson() {
        return this.gson;
    }

    public TransportClient getTransportClient() {
        return this.transportClient;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }

    public StreamingRules rules() {
        return new StreamingRules(this);
    }

    public StreamingStream stream() {
        return new StreamingStream(this);
    }

    @Override
    public void close() throws IOException {
        this.asyncHttpClient.close();
    }
}

