/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkNodePostProcessor
extends NodePostProcessor {
    private final Pattern ignoredLinks;
    private final boolean intellijDummyIdentifier;
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.WWW, LinkType.EMAIL)).build();

    public AutolinkNodePostProcessor(Document document) {
        String ignoreLinks = (String)AutolinkExtension.IGNORE_LINKS.getFrom((DataHolder)document);
        this.ignoredLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
        this.intellijDummyIdentifier = (Boolean)Parser.INTELLIJ_DUMMY_IDENTIFIER.getFrom((DataHolder)document);
    }

    public boolean isIgnoredLinkPrefix(CharSequence url) {
        if (this.ignoredLinks != null) {
            Matcher matcher = this.ignoredLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    public void process(NodeTracker state, Node node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        if (this.intellijDummyIdentifier) {
            literal = Escaping.removeAll((BasedSequence)literal, (CharSequence)"\u001f", (ReplacedTextMapper)textMapper);
        }
        Iterable links = this.linkExtractor.extractLinks((CharSequence)literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        for (LinkSpan link : links) {
            MailLink linkNode;
            BasedSequence linkText = literal.subSequence(link.getBeginIndex(), link.getEndIndex()).trimEnd();
            if (this.isIgnoredLinkPrefix((CharSequence)linkText)) continue;
            int startOffset = textMapper.originalOffset(link.getBeginIndex());
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                state.nodeAdded((Node)textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            BasedSequence linkChars = linkText.baseSubSequence(linkText.getStartOffset(), linkText.getEndOffset());
            Text contentNode = new Text(linkChars);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                linkNode.setText(linkChars);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkChars);
                ((AutoLink)linkNode).setUrlChars(linkChars);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild((Node)contentNode);
            textBase.appendChild((Node)linkNode);
            state.nodeAddedWithChildren((Node)linkNode);
            lastEscaped = textMapper.originalOffset(link.getBeginIndex() + linkText.length());
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, new Class[]{DoNotDecorate.class, DoNotLinkDecorate.class});
        }

        public NodePostProcessor create(Document document) {
            return new AutolinkNodePostProcessor(document);
        }
    }
}

