package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.parser.*;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;

import java.util.Set;
import java.util.regex.Pattern;

public class WebsiteLinkInlineParserExtension extends AutoLinkInlineParserExtensionBase {
    public WebsiteLinkInlineParserExtension(final InlineParser inlineParser) {
        super(inlineParser);
    }

    @Override
    protected Pattern getPattern() {
        return WEBSITE_AUTOLINK;
    }


    @Override
    protected Node getAutoLinkNode(final BasedSequence linkUrl) {
        AutoLink link = new AutoLink(BasedSequence.NULL, linkUrl, BasedSequence.NULL);
        link.setText(linkUrl);
        return link;
    }

    public static class Factory implements InlineTextParserExtensionFactory {
        @Override
        public Set<Class<? extends InlineTextParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public InlineTextParserExtension create(final InlineParser inlineParser) {
            return new WebsiteLinkInlineParserExtension(inlineParser);
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}
