/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumRefTextCollectingVisitor;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceOptions;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferences;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnumeratedReferenceNodeRenderer
implements PhasedNodeRenderer {
    private final EnumeratedReferenceOptions options;
    private EnumeratedReferences enumeratedOrdinals;
    private int ordinal;
    private final HtmlIdGenerator headerIdGenerator;

    public EnumeratedReferenceNodeRenderer(DataHolder options) {
        this.options = new EnumeratedReferenceOptions(options);
        this.ordinal = 0;
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
    }

    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.HEAD_TOP);
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.HEAD_TOP) {
            this.headerIdGenerator.generateIds(document);
        } else if (phase == RenderingPhase.BODY_TOP) {
            this.enumeratedOrdinals = (EnumeratedReferences)EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.getFrom((DataHolder)document);
        }
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(EnumeratedReferenceText.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceText>(){

            public void render(EnumeratedReferenceText node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(EnumeratedReferenceLink.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceLink>(){

            public void render(EnumeratedReferenceLink node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(EnumeratedReferenceBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceBlock>(){

            public void render(EnumeratedReferenceBlock node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(final EnumeratedReferenceLink node, final NodeRendererContext context, final HtmlWriter html) {
        final String text = node.getText().toString();
        if (text.isEmpty()) {
            html.text((CharSequence)String.valueOf(this.ordinal));
        } else {
            this.enumeratedOrdinals.renderReferenceOrdinals(text, null, new EnumeratedOrdinalRenderer(){

                @Override
                public void startRendering(EnumeratedReferenceRendering[] renderings) {
                    String title = new EnumRefTextCollectingVisitor().collectAndGetText(node.getChars().getBaseSequence(), renderings, null);
                    ((HtmlWriter)((HtmlWriter)html.withAttr().attr((CharSequence)"href", (CharSequence)("#" + text))).attr((CharSequence)"title", (CharSequence)title)).tag((CharSequence)"a");
                }

                @Override
                public void render(int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, boolean needSeparator) {
                    EnumeratedReferenceNodeRenderer.this.ordinal = referenceOrdinal;
                    if (needSeparator) {
                        html.text((CharSequence)".");
                    }
                    if (referenceFormat != null) {
                        context.renderChildren((Node)referenceFormat);
                    } else {
                        html.text((CharSequence)defaultText);
                    }
                }

                @Override
                public void endRendering() {
                    html.tag((CharSequence)"/a");
                }
            });
        }
    }

    private void render(EnumeratedReferenceText node, final NodeRendererContext context, final HtmlWriter html) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            html.text((CharSequence)String.valueOf(this.ordinal));
        } else {
            Node parent;
            String type = EnumeratedReferenceRepository.getType(text.toString());
            if ((type.isEmpty() || text.equals(type + ":")) && (parent = node.getAncestorOfType(new Class[]{Heading.class})) instanceof Heading) {
                text = (type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(parent);
            }
            this.enumeratedOrdinals.renderReferenceOrdinals(text, null, new EnumeratedOrdinalRenderer(){

                @Override
                public void startRendering(EnumeratedReferenceRendering[] renderings) {
                }

                @Override
                public void render(int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, boolean needSeparator) {
                    if (needSeparator) {
                        html.text((CharSequence)".");
                    }
                    if (referenceFormat != null) {
                        EnumeratedReferenceNodeRenderer.this.ordinal = referenceOrdinal;
                        context.renderChildren((Node)referenceFormat);
                    } else {
                        html.text((CharSequence)defaultText);
                    }
                }

                @Override
                public void endRendering() {
                }
            });
        }
    }

    private void render(EnumeratedReferenceBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new EnumeratedReferenceNodeRenderer(options);
        }
    }
}

