/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.toc.internal.TocOptionsParser;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.TextCollectingAppendable;
import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.Escaping;
import com.vladsch.flexmark.util.ValueRunnable;
import com.vladsch.flexmark.util.options.DelimitedBuilder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.List;

public class TocUtils {
    public static final AttributablePart TOC_CONTENT = new AttributablePart("TOC_CONTENT");

    public static String getTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        TocOptionsParser optionsParser = new TocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]");
        out.append("\n").unmark();
        return out.toString();
    }

    public static String getSimTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        SimTocOptionsParser optionsParser = new SimTocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]:").mark().append('#').mark();
        String optionTitleHeading = options.getTitleHeading();
        String optionTitle = options.title;
        if (defaultOptions == null || !optionTitleHeading.equals(defaultOptions.getTitleHeading())) {
            if (!optionTitle.isEmpty()) {
                out.append('\"');
                if (defaultOptions == null || options.titleLevel != defaultOptions.titleLevel) {
                    out.append(optionTitleHeading);
                } else {
                    out.append(optionTitle);
                }
                out.append('\"').mark();
            } else {
                out.append("\"\"").mark();
            }
        }
        out.unmark().append("\n").unmark();
        return out.toString();
    }

    public static void renderTocContent(HtmlWriter out, String tocContents, TocOptions options, List<Heading> headings, List<String> headingTexts) {
        if (headings.isEmpty()) {
            return;
        }
        if (options.isHtml) {
            TocUtils.renderHtmlToc(out, SubSequence.NULL, headings, headingTexts, options);
        } else {
            TocUtils.renderMarkdownToc(out, headings, headingTexts, options);
        }
    }

    public static void renderHtmlToc(HtmlWriter html, BasedSequence sourceText, List<Heading> headings, List<String> headingTexts, TocOptions tocOptions) {
        int i;
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.isEmpty())) {
            if (sourceText.isNotNull()) {
                html.srcPos(sourceText);
            }
            html.withAttr(TOC_CONTENT).tag("div").line().indent();
            html.tag("h" + tocOptions.titleLevel).text(tocOptions.title).tag("/h" + tocOptions.titleLevel).line();
        }
        int initLevel = -1;
        int lastLevel = -1;
        String listOpen = tocOptions.isNumbered ? "ol" : "ul";
        String listClose = "/" + listOpen;
        boolean listNesting = false;
        boolean[] openedItems = new boolean[7];
        boolean[] openedList = new boolean[7];
        int[] openedItemAppendCount = new int[7];
        for (i = 0; i < headings.size(); ++i) {
            Heading header = headings.get(i);
            String headerText = headingTexts.get(i);
            int headerLevel = header.getLevel();
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
                html.withAttr().line().tag(listOpen).indent().line();
                openedList[0] = true;
            }
            if (lastLevel < headerLevel) {
                for (int lv = lastLevel; lv < headerLevel; ++lv) {
                    openedItems[lv + 1] = false;
                    openedList[lv + 1] = false;
                }
                if (!openedList[lastLevel]) {
                    html.withAttr().indent().line().tag(listOpen).indent();
                    openedList[lastLevel] = true;
                }
            } else if (lastLevel == headerLevel) {
                if (openedItems[lastLevel]) {
                    if (openedList[lastLevel]) {
                        html.unIndent().tag(listClose).line();
                    }
                    html.lineIf(openedItemAppendCount[lastLevel] != html.getAppendCount()).tag("/li").line();
                }
                openedItems[lastLevel] = false;
                openedList[lastLevel] = false;
            } else {
                for (int lv = lastLevel; lv >= headerLevel; --lv) {
                    if (openedItems[lv]) {
                        if (openedList[lv]) {
                            html.unIndent().tag(listClose).unIndent().line();
                        }
                        html.lineIf(openedItemAppendCount[lastLevel] != html.getAppendCount()).tag("/li").line();
                    }
                    openedItems[lv] = false;
                    openedList[lv] = false;
                }
            }
            html.line().tag("li");
            openedItems[headerLevel] = true;
            String headerId = header.getAnchorRefId();
            if (headerId == null || headerId.isEmpty()) {
                html.raw(headerText);
            } else {
                html.attr("href", "#" + headerId).withAttr().tag("a");
                html.raw(headerText);
                html.tag("/a");
            }
            lastLevel = headerLevel;
            openedItemAppendCount[headerLevel] = html.getAppendCount();
        }
        for (i = lastLevel; i >= 1; --i) {
            if (!openedItems[i]) continue;
            if (openedList[i]) {
                html.unIndent().tag(listClose).unIndent().line();
            }
            html.lineIf(openedItemAppendCount[lastLevel] != html.getAppendCount()).tag("/li").line();
        }
        if (openedList[0]) {
            html.unIndent().tag(listClose).line();
        }
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.isEmpty())) {
            html.line().unIndent().tag("/div");
        }
        html.line();
    }

    public static List<Heading> filteredHeadings(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<Heading> filteredHeadings = new ArrayList<Heading>(headings.size());
        for (Heading header : headings) {
            if (!tocOptions.isLevelIncluded(header.getLevel()) || header.getParent() instanceof SimTocContent) continue;
            filteredHeadings.add(header);
        }
        return filteredHeadings;
    }

    public static List<String> htmlHeaderTexts(NodeRendererContext context, List<Heading> headings, TocOptions tocOptions) {
        ArrayList<String> headerTexts = new ArrayList<String>(headings.size());
        for (Heading header : headings) {
            String headerText;
            if (tocOptions.isTextOnly) {
                headerText = Escaping.escapeHtml((String)new TextCollectingVisitor().collectAndGetText((Node)header), (boolean)false);
                boolean isRaw = false;
            } else {
                TextCollectingAppendable out = new TextCollectingAppendable();
                NodeRendererContext subContext = context.getSubContext((Appendable)out, false);
                subContext.doNotRenderLinks();
                subContext.renderChildren((Node)header);
                headerText = out.getHtml();
            }
            headerTexts.add(headerText);
        }
        return headerTexts;
    }

    public static List<String> markdownHeaderTexts(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<String> headingTexts = new ArrayList<String>(headings.size());
        for (Heading header : headings) {
            String headerText = tocOptions.isTextOnly ? new TextCollectingVisitor().collectAndGetText((Node)header) : header.getChars().toString();
            String headerId = header.getAnchorRefId();
            String headerLink = headerId == null || headerText.isEmpty() ? headerText : "[" + headerText + "](#" + headerId + ")";
            headingTexts.add(headerLink);
        }
        return headingTexts;
    }

    public static void renderMarkdownToc(HtmlWriter html, List<Heading> headings, List<String> headingTexts, TocOptions tocOptions) {
        int initLevel = -1;
        int lastLevel = -1;
        int[] headingNumbers = new int[7];
        boolean[] openedItems = new boolean[7];
        Computable listOpen = level -> {
            openedItems[level.intValue()] = true;
            if (tocOptions.isNumbered) {
                int n = level;
                int n2 = headingNumbers[n] + 1;
                headingNumbers[n] = n2;
                int v = n2;
                return v + ". ";
            }
            return "- ";
        };
        ValueRunnable listClose = level -> {
            if (tocOptions.isNumbered) {
                headingNumbers[level.intValue()] = 0;
            }
        };
        if (headings.size() > 0 && !tocOptions.title.isEmpty()) {
            html.raw("######".substring(0, tocOptions.titleLevel)).raw(" ").raw(tocOptions.title).line();
        }
        for (int i = 0; i < headings.size(); ++i) {
            int lv;
            Heading header = headings.get(i);
            String headerText = headingTexts.get(i);
            int headerLevel = header.getLevel();
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
            }
            if (lastLevel < headerLevel) {
                for (lv = lastLevel; lv <= headerLevel - 1; ++lv) {
                    openedItems[lv + 1] = false;
                }
                html.indent();
            } else if (lastLevel == headerLevel) {
                if (i != 0) {
                    html.line();
                }
            } else {
                for (lv = lastLevel; lv >= headerLevel + 1; ++lv) {
                    if (!openedItems[lv]) continue;
                    html.unIndent();
                    listClose.run((Object)lv);
                }
                html.line();
            }
            html.line().raw((String)listOpen.compute((Object)headerLevel));
            html.raw(headerText);
            lastLevel = headerLevel;
        }
        html.line();
    }
}

