/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.util.options.DataHolder;

public class SimTocOptions
extends TocOptions {
    public final boolean isAstAddOptions;
    public final boolean isBlankLineSpacer;

    public SimTocOptions() {
        this(12, false, false, false, 1, "Table of Contents", false, true);
    }

    public SimTocOptions(DataHolder options) {
        super(options);
        this.isAstAddOptions = (Boolean)options.get(SimTocExtension.AST_INCLUDE_OPTIONS);
        this.isBlankLineSpacer = (Boolean)options.get(SimTocExtension.BLANK_LINE_SPACER);
    }

    public SimTocOptions(int levels, boolean isHtml, boolean isTextOnly, boolean isNumbered, int titleLevel, String title, boolean isAstAddOptions, boolean isBlankLineSpacer) {
        super(levels, isHtml, isTextOnly, isNumbered, titleLevel, title);
        this.isAstAddOptions = isAstAddOptions;
        this.isBlankLineSpacer = isBlankLineSpacer;
    }

    @Override
    public boolean isLevelIncluded(int level) {
        return level >= 1 && level <= 6 && (this.levels & 1 << level) != 0;
    }

    @Override
    public SimTocOptions withLevels(int levels) {
        return new SimTocOptions(levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withIsHtml(boolean isHtml) {
        return new SimTocOptions(this.levels, isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withIsTextOnly(boolean isTextOnly) {
        return new SimTocOptions(this.levels, this.isHtml, isTextOnly, this.isNumbered, this.titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withIsNumbered(boolean isNumbered) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, isNumbered, this.titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withTitleLevel(int titleLevel) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withTitle(String title) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withRawTitleLevel(int titleLevel) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withRawTitle(String title) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public SimTocOptions withIsAstAddOptions(boolean isAstAddOptions) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, isAstAddOptions, this.isBlankLineSpacer);
    }

    public SimTocOptions withIsBlankLineSpacer(boolean isBlankLineSpacer) {
        return new SimTocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.isAstAddOptions, isBlankLineSpacer);
    }

    @Override
    public SimTocOptions withLevelList(int ... levelList) {
        int levels = 0;
        for (int level : levelList) {
            if (level < 1 || level > 6) {
                throw new IllegalArgumentException("TocOption level out of range [1, 6]");
            }
            levels |= 1 << level;
        }
        return new SimTocOptions(levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.isAstAddOptions, this.isBlankLineSpacer);
    }
}

