/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.IRender;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.formatter.internal.FormatterOptions;
import com.vladsch.flexmark.formatter.internal.FormattingPhase;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormatterSubContext;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.PhasedNodeFormatter;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.collection.DynamicDefaultKey;
import com.vladsch.flexmark.util.collection.NodeCollectingVisitor;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.ScopedDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Formatter
implements IRender {
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey("FORMAT_FLAGS", (Object)0);
    public static final int FORMAT_CONVERT_TABS = 1;
    public static final int FORMAT_COLLAPSE_WHITESPACE = 2;
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = 4;
    public static final int FORMAT_ALL_OPTIONS = 7;
    public static final DataKey<Integer> MAX_BLANK_LINES = new DataKey("MAX_BLANK_LINES", (Object)2);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey("MAX_TRAILING_BLANK_LINES", (Object)1);
    public static final DataKey<DiscretionaryText> SPACE_AFTER_ATX_MARKER = new DataKey("SPACE_AFTER_ATX_MARKER", (Object)DiscretionaryText.ADD);
    public static final DataKey<Boolean> SETEXT_HEADER_EQUALIZE_MARKER = new DataKey("SETEXT_HEADER_EQUALIZE_MARKER", (Object)true);
    public static final DataKey<EqualizeTrailingMarker> ATX_HEADER_TRAILING_MARKER = new DataKey("ATX_HEADER_TRAILING_MARKER", (Object)EqualizeTrailingMarker.AS_IS);
    public static final DataKey<String> THEMATIC_BREAK = new DataKey("THEMATIC_BREAK", (Object)null);
    public static final DataKey<Boolean> BLOCK_QUOTE_BLANK_LINES = new DataKey("BLOCK_QUOTE_BLANK_LINES", (Object)true);
    public static final DataKey<BlockQuoteMarker> BLOCK_QUOTE_MARKERS = new DataKey("BLOCK_QUOTE_MARKERS", (Object)BlockQuoteMarker.ADD_COMPACT_WITH_SPACE);
    public static final DataKey<Boolean> INDENTED_CODE_MINIMIZE_INDENT = new DataKey("INDENTED_CODE_MINIMIZE_INDENT", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_MINIMIZE_INDENT = new DataKey("FENCED_CODE_MINIMIZE_INDENT", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_MATCH_CLOSING_MARKER = new DataKey("FENCED_CODE_MATCH_CLOSING_MARKER", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_SPACE_BEFORE_INFO = new DataKey("FENCED_CODE_SPACE_BEFORE_INFO", (Object)false);
    public static final DataKey<Integer> FENCED_CODE_MARKER_LENGTH = new DataKey("FENCED_CODE_MARKER_LENGTH", (Object)3);
    public static final DataKey<CodeFenceMarker> FENCED_CODE_MARKER_TYPE = new DataKey("FENCED_CODE_MARKER_TYPE", (Object)CodeFenceMarker.ANY);
    public static final DataKey<Boolean> LIST_ADD_BLANK_LINE_BEFORE = new DataKey("LIST_ADD_BLANK_LINE_BEFORE", (Object)false);
    public static final DataKey<Boolean> LIST_RENUMBER_ITEMS = new DataKey("LIST_RENUMBER_ITEMS", (Object)true);
    public static final DataKey<ListBulletMarker> LIST_BULLET_MARKER = new DataKey("LIST_BULLET_MARKER", (Object)ListBulletMarker.ANY);
    public static final DataKey<ListNumberedMarker> LIST_NUMBERED_MARKER = new DataKey("LIST_NUMBERED_MARKER", (Object)ListNumberedMarker.ANY);
    public static final DataKey<ListSpacing> LIST_SPACING = new DataKey("LIST_SPACING", (Object)ListSpacing.AS_IS);
    public static final DataKey<ElementPlacement> REFERENCE_PLACEMENT = new DataKey("REFERENCE_PLACEMENT", (Object)ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> REFERENCE_SORT = new DataKey("REFERENCE_SORT", (Object)ElementPlacementSort.AS_IS);
    public static final DataKey<Boolean> KEEP_IMAGE_LINKS_AT_START = new DataKey("KEEP_IMAGE_LINKS_AT_START", (Object)false);
    public static final DataKey<Boolean> KEEP_EXPLICIT_LINKS_AT_START = new DataKey("KEEP_EXPLICIT_LINKS_AT_START", (Object)false);
    public static final DataKey<CharWidthProvider> CHAR_WIDTH_PROVIDER = TableFormatOptions.CHAR_WIDTH_PROVIDER;
    public static final DataKey<ParserEmulationProfile> FORMATTER_EMULATION_PROFILE = new DynamicDefaultKey("FORMATTER_EMULATION_PROFILE", Parser.PARSER_EMULATION_PROFILE);
    private final List<NodeFormatterFactory> nodeFormatterFactories;
    private final FormatterOptions formatterOptions;
    private final DataHolder options;
    private final Builder builder;
    private static final Iterator<? extends Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    private static final Iterable<? extends Node> NULL_ITERABLE = new Iterable<Node>(){

        @Override
        public Iterator<Node> iterator() {
            return null;
        }
    };

    private Formatter(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.formatterOptions = new FormatterOptions(this.options);
        this.nodeFormatterFactories = new ArrayList<NodeFormatterFactory>(builder.nodeFormatterFactories.size() + 1);
        this.nodeFormatterFactories.addAll(builder.nodeFormatterFactories);
        this.nodeFormatterFactories.add(new NodeFormatterFactory(){

            @Override
            public NodeFormatter create(DataHolder options) {
                return new CoreNodeFormatter(options);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public void render(Node node, Appendable output) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument());
        renderer.render(node);
        renderer.flush(this.formatterOptions.maxTrailingBlankLines);
    }

    public void render(Node node, Appendable output, int maxTrailingBlankLines) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument());
        renderer.render(node);
        renderer.flush(maxTrailingBlankLines);
    }

    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    public Formatter withOptions(DataHolder options) {
        return options == null ? this : new Formatter(new Builder(this.builder, options));
    }

    private class MainNodeFormatter
    extends NodeFormatterSubContext
    implements NodeFormatterContext {
        private final Document document;
        private final Map<Class<?>, NodeFormattingHandler> renderers;
        private final SubClassingBag<Node> collectedNodes;
        private final List<PhasedNodeFormatter> phasedFormatters;
        private final Set<FormattingPhase> renderingPhases;
        private final DataHolder options;
        private FormattingPhase phase;

        MainNodeFormatter(DataHolder options, MarkdownWriter out, Document document) {
            super(out);
            this.options = new ScopedDataSet((DataHolder)document, options);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<FormattingPhase>(FormattingPhase.values().length);
            HashSet collectNodeTypes = new HashSet(100);
            this.phasedFormatters = new ArrayList<PhasedNodeFormatter>(Formatter.this.nodeFormatterFactories.size());
            out.setContext(this);
            for (int i = Formatter.this.nodeFormatterFactories.size() - 1; i >= 0; --i) {
                NodeFormatterFactory nodeFormatterFactory = (NodeFormatterFactory)Formatter.this.nodeFormatterFactories.get(i);
                NodeFormatter nodeFormatter = nodeFormatterFactory.create(this.getOptions());
                Set<NodeFormattingHandler<?>> formattingHandlers = nodeFormatter.getNodeFormattingHandlers();
                if (formattingHandlers == null) continue;
                for (NodeFormattingHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getNodeType(), nodeType);
                }
                Set<Class<?>> nodeClasses = nodeFormatter.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if (!(nodeFormatter instanceof PhasedNodeFormatter)) continue;
                Set<FormattingPhase> phases = ((PhasedNodeFormatter)nodeFormatter).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeFormatter)nodeFormatter);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect((Node)document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
        }

        @Override
        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public FormatterOptions getFormatterOptions() {
            return Formatter.this.formatterOptions;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public FormattingPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(Node node) {
            this.renderNode(node, this);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        @Override
        public NodeFormatterContext getSubContext(Appendable out) {
            MarkdownWriter writer = new MarkdownWriter(out, this.getMarkdown().getOptions());
            writer.setContext(this);
            return new SubNodeFormatter(this, writer);
        }

        void renderNode(Node node, NodeFormatterSubContext subContext) {
            if (node instanceof Document) {
                for (FormattingPhase phase : FormattingPhase.values()) {
                    if (phase != FormattingPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.getFormattingPhase() == FormattingPhase.DOCUMENT) {
                        NodeFormattingHandler nodeRenderer = this.renderers.get(node.getClass());
                        if (nodeRenderer == null) continue;
                        subContext.renderingNode = node;
                        nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                        subContext.renderingNode = null;
                        continue;
                    }
                    for (PhasedNodeFormatter phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        subContext.renderingNode = node;
                        phasedFormatter.renderDocument(subContext, subContext.markdown, (Document)node, phase);
                        subContext.renderingNode = null;
                    }
                }
            } else {
                NodeFormattingHandler nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(Node.class);
                }
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    subContext.renderingNode = node;
                    nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                    subContext.renderingNode = oldNode;
                } else {
                    throw new IllegalStateException("Core Node Formatter should implement generic Node renderer");
                }
            }
        }

        @Override
        public void renderChildren(Node parent) {
            this.renderChildrenNode(parent, this);
        }

        protected void renderChildrenNode(Node parent, NodeFormatterSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeFormatter
        extends NodeFormatterSubContext
        implements NodeFormatterContext {
            private final MainNodeFormatter myMainNodeRenderer;

            public SubNodeFormatter(MainNodeFormatter mainNodeRenderer, MarkdownWriter out) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            public FormatterOptions getFormatterOptions() {
                return this.myMainNodeRenderer.getFormatterOptions();
            }

            @Override
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public FormattingPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public Node getCurrentNode() {
                return this.myMainNodeRenderer.getCurrentNode();
            }

            @Override
            public NodeFormatterContext getSubContext(Appendable out) {
                MarkdownWriter htmlWriter = new MarkdownWriter(out, this.markdown.getOptions());
                htmlWriter.setContext(this);
                return new SubNodeFormatter(this.myMainNodeRenderer, htmlWriter);
            }

            @Override
            public void renderChildren(Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            public MarkdownWriter getMarkdown() {
                return this.markdown;
            }
        }
    }

    public static interface FormatterExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends MutableDataSet {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeFormatterFactory> nodeFormatterFactories = new ArrayList<NodeFormatterFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        private final HashSet<FormatterExtension> loadedExtensions = new HashSet();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            if (options.contains(Parser.EXTENSIONS)) {
                this.extensions((Iterable)this.get(Parser.EXTENSIONS));
            }
        }

        public Builder(Builder other) {
            super((DataHolder)other);
            this.attributeProviderFactories.addAll(other.attributeProviderFactories);
            this.nodeFormatterFactories.addAll(other.nodeFormatterFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
            this.loadedExtensions.addAll(other.loadedExtensions);
            this.htmlIdGeneratorFactory = other.htmlIdGeneratorFactory;
        }

        public Builder(Builder other, DataHolder options) {
            super((DataHolder)other);
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (Extension extension : (Iterable)this.get(Parser.EXTENSIONS)) {
                extensions.add(extension);
            }
            if (options != null) {
                for (DataKey key : options.keySet()) {
                    if (key == Parser.EXTENSIONS) {
                        for (Extension extension : (Iterable)options.get(Parser.EXTENSIONS)) {
                            extensions.add(extension);
                        }
                        continue;
                    }
                    this.set(key, options.get(key));
                }
            }
            this.set(Parser.EXTENSIONS, extensions);
            this.extensions(extensions);
        }

        public Formatter build() {
            return new Formatter(this);
        }

        public Builder nodeFormatterFactory(NodeFormatterFactory nodeFormatterFactory) {
            this.nodeFormatterFactories.add(nodeFormatterFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            FormatterExtension formatterExtension;
            for (Extension extension : extensions) {
                if (!(extension instanceof FormatterExtension) || this.loadedExtensions.contains(extension)) continue;
                formatterExtension = (FormatterExtension)extension;
                formatterExtension.rendererOptions((MutableDataHolder)this);
            }
            for (Extension extension : extensions) {
                if (!(extension instanceof FormatterExtension) || this.loadedExtensions.contains(extension)) continue;
                formatterExtension = (FormatterExtension)extension;
                formatterExtension.extend(this);
                this.loadedExtensions.add(formatterExtension);
            }
            return this;
        }
    }
}

