/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.convert.html;

import com.vladsch.flexmark.convert.html.HtmlParserOptions;
import com.vladsch.flexmark.ext.emoji.internal.EmojiCheatSheet;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.RomanNumeral;
import com.vladsch.flexmark.util.format.Table;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.FormattingAppendableImpl;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class FlexmarkHtmlParser {
    public static final DataKey<Boolean> LIST_CONTENT_INDENT = new DataKey("LIST_CONTENT_INDENT", (Object)true);
    public static final DataKey<Boolean> SETEXT_HEADINGS = new DataKey("SETEXT_HEADINGS", (Object)true);
    public static final DataKey<Boolean> OUTPUT_UNKNOWN_TAGS = new DataKey("OUTPUT_UNKNOWN_TAGS", (Object)false);
    public static final DataKey<Boolean> TYPOGRAPHIC_QUOTES = new DataKey("TYPOGRAPHIC_QUOTES", (Object)true);
    public static final DataKey<Boolean> TYPOGRAPHIC_SMARTS = new DataKey("TYPOGRAPHIC_SMARTS", (Object)true);
    public static final DataKey<Boolean> EXTRACT_AUTO_LINKS = new DataKey("EXTRACT_AUTO_LINKS", (Object)true);
    public static final DataKey<Boolean> WRAP_AUTO_LINKS = new DataKey("WRAP_AUTO_LINKS", (Object)false);
    public static final DataKey<Boolean> RENDER_COMMENTS = new DataKey("RENDER_COMMENTS", (Object)false);
    public static final DataKey<Boolean> DOT_ONLY_NUMERIC_LISTS = new DataKey("DOT_ONLY_NUMERIC_LISTS", (Object)true);
    public static final DataKey<Boolean> PRE_CODE_PRESERVE_EMPHASIS = new DataKey("PRE_CODE_PRESERVE_EMPHASIS", (Object)false);
    public static final DataKey<Character> ORDERED_LIST_DELIMITER = new DataKey("ORDERED_LIST_DELIMITER", (Object)Character.valueOf('.'));
    public static final DataKey<Character> UNORDERED_LIST_DELIMITER = new DataKey("UNORDERED_LIST_DELIMITER", (Object)Character.valueOf('*'));
    public static final DataKey<Integer> DEFINITION_MARKER_SPACES = new DataKey("DEFINITION_MARKER_SPACES", (Object)3);
    public static final DataKey<Integer> MIN_SETEXT_HEADING_MARKER_LENGTH = new DataKey("MIN_SETEXT_HEADING_MARKER_LENGTH", (Object)3);
    public static final DataKey<String> CODE_INDENT = new DataKey("CODE_INDENT", (Object)"    ");
    public static final DataKey<String> NBSP_TEXT = new DataKey("NBSP_TEXT", (Object)" ");
    public static final DataKey<String> EOL_IN_TITLE_ATTRIBUTE = new DataKey("EOL_IN_TITLE_ATTRIBUTE", (Object)" ");
    public static final DataKey<String> THEMATIC_BREAK = new DataKey("THEMATIC_BREAK", (Object)"*** ** * ** ***");
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_COLUMN_WIDTH = TableFormatOptions.MIN_SEPARATOR_COLUMN_WIDTH;
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_DASHES = TableFormatOptions.MIN_SEPARATOR_DASHES;
    public static final DataKey<Boolean> TABLE_LEAD_TRAIL_PIPES = TableFormatOptions.LEAD_TRAIL_PIPES;
    public static final DataKey<Boolean> TABLE_SPACE_AROUND_PIPES = TableFormatOptions.SPACE_AROUND_PIPES;
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey("LISTS_END_ON_DOUBLE_BLANK", (Object)false);
    private static final Map<Object, CellAlignment> tableCellAlignments = new LinkedHashMap<Object, CellAlignment>();
    private static final Map<String, String> typographicMap;
    private static final String typographicQuotes = "\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;";
    private static final String typographicSmarts = "\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;";
    private static final Pattern NUMERIC_DOT_LIST;
    private static final Pattern NUMERIC_PAREN_LIST;
    private static final Pattern NON_NUMERIC_DOT_LIST;
    private static final Pattern NON_NUMERIC_PAREN_LIST;
    public static final DataKey<Map<Object, CellAlignment>> TABLE_CELL_ALIGNMENT_MAP;
    private final HtmlParserOptions myOptions;
    private final Pattern typographicPattern;
    private Stack<State> myStateStack;
    private Map<String, String> myAbbreviations;
    private State myState;
    private boolean myTrace;
    private Table myTable;
    private static final Map<String, TagParam> ourTagProcessors;

    private FlexmarkHtmlParser(DataHolder options) {
        this.myOptions = new HtmlParserOptions(options);
        this.typographicPattern = this.myOptions.typographicQuotes && this.myOptions.typographicSmarts ? Pattern.compile("\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;|\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;") : (this.myOptions.typographicQuotes ? Pattern.compile(typographicQuotes) : (this.myOptions.typographicSmarts ? Pattern.compile(typographicSmarts) : null));
        this.resetForParse();
    }

    private void resetForParse() {
        this.myStateStack = new Stack();
        this.myAbbreviations = new HashMap<String, String>();
        this.myState = null;
    }

    public HtmlParserOptions getOptions() {
        return this.myOptions;
    }

    public boolean isTrace() {
        return this.myTrace;
    }

    public void setTrace(boolean trace) {
        this.myTrace = trace;
    }

    public void parse(FormattingAppendable out, String html) {
        this.resetForParse();
        Document document = Jsoup.parse((String)html);
        Element body = document.body();
        if (this.myTrace) {
            FormattingAppendableImpl trace = new FormattingAppendableImpl(0);
            trace.setIndentPrefix((CharSequence)"  ");
            this.dumpHtmlTree((FormattingAppendable)trace, (Node)body);
            trace.flush();
            System.out.println(trace.getAppendable());
        }
        this.processHtmlTree(out, (Node)body);
        out.blankLine();
        if (!this.myAbbreviations.isEmpty()) {
            for (Map.Entry<String, String> entry : this.myAbbreviations.entrySet()) {
                out.line().append((CharSequence)"*[").append((CharSequence)entry.getKey()).append((CharSequence)"]: ").append((CharSequence)entry.getValue()).line();
            }
        }
        out.blankLine();
    }

    public static FlexmarkHtmlParser build() {
        return new FlexmarkHtmlParser(null);
    }

    public static FlexmarkHtmlParser build(DataHolder options) {
        return new FlexmarkHtmlParser(options);
    }

    public void dumpHtmlTree(FormattingAppendable out, Node node) {
        out.line().append((CharSequence)node.nodeName());
        for (Attribute attribute : node.attributes().asList()) {
            out.append(' ').append((CharSequence)attribute.getKey()).append((CharSequence)"=\"").append((CharSequence)attribute.getValue()).append((CharSequence)"\"");
        }
        out.line().indent();
        for (Node child : node.childNodes()) {
            this.dumpHtmlTree(out, child);
        }
        out.unIndent();
    }

    public static String parse(String html) {
        return FlexmarkHtmlParser.parse(html, 0);
    }

    public static String parse(String html, int maxBlankLines) {
        return FlexmarkHtmlParser.parse(html, maxBlankLines, null);
    }

    public static String parse(String html, int maxBlankLines, DataHolder options) {
        FormattingAppendableImpl out = new FormattingAppendableImpl(6);
        FlexmarkHtmlParser parser = new FlexmarkHtmlParser(options);
        parser.parse((FormattingAppendable)out, html);
        return out.getText(maxBlankLines);
    }

    private String dumpState() {
        if (!this.myStateStack.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            while (!this.myStateStack.isEmpty()) {
                State state = this.myStateStack.pop();
                sb.append("\n").append(state.toString());
            }
            return sb.toString();
        }
        return "";
    }

    private void processHtmlTree(FormattingAppendable out, Node parent) {
        Node node;
        this.pushState(parent);
        State oldState = this.myState;
        while ((node = this.peek()) != null) {
            this.processElement(out, node);
        }
        if (oldState != this.myState) {
            throw new IllegalStateException("State not equal after process " + this.dumpState());
        }
        this.popState();
    }

    private void processElement(FormattingAppendable out, Node node) {
        TagParam tagParam = this.getTagParam(node);
        boolean processed = false;
        if (tagParam != null) {
            switch (tagParam.tagType) {
                case A: {
                    processed = this.processA(out, (Element)node);
                    break;
                }
                case BR: {
                    processed = this.processBr(out, (Element)node);
                    break;
                }
                case ABBR: {
                    processed = this.processAbbr(out, (Element)node);
                    break;
                }
                case ASIDE: {
                    processed = this.processAside(out, (Element)node);
                    break;
                }
                case BLOCKQUOTE: {
                    processed = this.processBlockquote(out, (Element)node);
                    break;
                }
                case CODE: {
                    processed = this.processCode(out, (Element)node);
                    break;
                }
                case DEL: {
                    processed = this.processDel(out, (Element)node);
                    break;
                }
                case DIV: {
                    processed = this.processDiv(out, (Element)node);
                    break;
                }
                case DL: {
                    processed = this.processDl(out, (Element)node);
                    break;
                }
                case _EMPHASIS: {
                    processed = this.processEmphasis(out, (Element)node);
                    break;
                }
                case HR: {
                    processed = this.processHr(out, (Element)node);
                    break;
                }
                case IMG: {
                    processed = this.processImg(out, (Element)node);
                    break;
                }
                case INPUT: {
                    processed = this.processInput(out, (Element)node);
                    break;
                }
                case INS: {
                    processed = this.processIns(out, (Element)node);
                    break;
                }
                case OL: {
                    processed = this.processOl(out, (Element)node);
                    break;
                }
                case P: {
                    processed = this.processP(out, (Element)node);
                    break;
                }
                case PRE: {
                    processed = this.processPre(out, (Element)node);
                    break;
                }
                case _STRONG_EMPHASIS: {
                    processed = this.processStrong(out, (Element)node);
                    break;
                }
                case SUB: {
                    processed = this.processSub(out, (Element)node);
                    break;
                }
                case SUP: {
                    processed = this.processSup(out, (Element)node);
                    break;
                }
                case SVG: {
                    processed = this.processSvg(out, (Element)node);
                    break;
                }
                case UL: {
                    processed = this.processUl(out, (Element)node);
                    break;
                }
                case LI: {
                    processed = this.processList(out, (Element)node, false, true);
                    break;
                }
                case TABLE: {
                    processed = this.processTable(out, (Element)node);
                    break;
                }
                case _UNWRAPPED: {
                    processed = this.processUnwrapped(out, node);
                    break;
                }
                case _SPAN: {
                    processed = this.processSpan(out, (Element)node);
                    break;
                }
                case _WRAPPED: {
                    processed = this.processWrapped(out, node, tagParam.param == null);
                    break;
                }
                case _COMMENT: {
                    processed = this.processComment(out, (Comment)node);
                    break;
                }
                case _HEADING: {
                    processed = this.processHeading(out, (Element)node);
                    break;
                }
                case _TEXT: {
                    processed = this.processText(out, (TextNode)node);
                    break;
                }
            }
        } else if (node instanceof Element) {
            processed = this.processEmoji(out, (Element)node);
        }
        if (!processed) {
            if (this.myOptions.outputUnknownTags) {
                this.processWrapped(out, node, null);
            } else {
                this.processUnwrapped(out, node);
            }
        }
    }

    private boolean processWrapped(FormattingAppendable out, Node node, Boolean isBlock) {
        if (node instanceof Element && (isBlock == null && ((Element)node).isBlock() || isBlock != null && isBlock.booleanValue())) {
            String s = node.toString();
            int pos = s.indexOf(">");
            out.lineIf(isBlock != null).append((CharSequence)s.substring(0, pos + 1)).lineIf(isBlock != null);
            this.next();
            this.processHtmlTree(out, node);
            int endPos = s.lastIndexOf("<");
            out.lineIf(isBlock != null).append((CharSequence)s.substring(endPos)).lineIf(isBlock != null);
        } else {
            out.append((CharSequence)node.toString());
            this.next();
        }
        return true;
    }

    private String prepareText(String text) {
        if (this.typographicPattern != null) {
            Matcher matcher = this.typographicPattern.matcher(text);
            int length = text.length();
            StringBuilder sb = new StringBuilder(length * 2);
            int lastPos = 0;
            while (matcher.find()) {
                if (lastPos < matcher.start()) {
                    sb.append(text, lastPos, matcher.start());
                }
                sb.append(typographicMap.get(matcher.group()));
                lastPos = matcher.end();
            }
            if (lastPos < length) {
                sb.append(text, lastPos, length);
            }
            text = sb.toString();
        }
        return text.replace("\\", "\\\\").replace("\u00a0", this.myOptions.nbspText);
    }

    private boolean processText(FormattingAppendable out, TextNode node) {
        this.skip();
        if (out.isPreFormatted()) {
            out.append((CharSequence)this.prepareText(node.getWholeText()));
        } else {
            out.append((CharSequence)this.prepareText(node.text()));
        }
        return true;
    }

    private void processTextNodes(FormattingAppendable out, Node node) {
        this.processTextNodes(out, node, null, null);
    }

    private void processTextNodes(FormattingAppendable out, Node node, CharSequence wrapText) {
        this.processTextNodes(out, node, wrapText, wrapText);
    }

    private void processTextNodes(FormattingAppendable out, Node node, CharSequence textPrefix, CharSequence textSuffix) {
        Node child;
        this.pushState(node);
        while ((child = this.peek()) != null) {
            if (child instanceof TextNode) {
                if (textPrefix != null && textPrefix.length() > 0) {
                    out.append(textPrefix);
                }
                String text = ((TextNode)child).getWholeText();
                String preparedText = this.prepareText(text);
                out.append((CharSequence)preparedText);
                if (textSuffix != null && textSuffix.length() > 0) {
                    out.append(textSuffix);
                }
                this.skip();
                continue;
            }
            if (child instanceof Element) {
                this.processElement(out, child);
                continue;
            }
            this.skip();
        }
        this.popState();
    }

    private void wrapTextNodes(FormattingAppendable out, Node node, CharSequence wrapText, boolean needSpaceAround) {
        String text = this.processTextNodes(node);
        String prefixBefore = null;
        String appendAfter = null;
        boolean addSpaceBefore = false;
        boolean addSpaceAfter = false;
        if (!text.isEmpty() && needSpaceAround) {
            if ("\u00a0 \t\n".indexOf(text.charAt(0)) != -1) {
                prefixBefore = this.prepareText(text.substring(0, 1));
                text = text.substring(1);
            } else if (text.startsWith("&nbsp;")) {
                prefixBefore = "&nbsp;";
                text = text.substring(prefixBefore.length());
            } else {
                boolean bl = addSpaceBefore = !out.isPendingEOL() && !out.isPendingSpace() && out.getModCount() != 0;
            }
            if ("\u00a0 \t\n".indexOf(text.charAt(text.length() - 1)) != -1) {
                appendAfter = this.prepareText(text.substring(text.length() - 1));
                text = text.substring(0, text.length() - 1);
            } else if (text.endsWith("&nbsp;")) {
                appendAfter = "&nbsp;";
                text = text.substring(0, text.length() - appendAfter.length());
            } else {
                String nextText;
                Node next = this.peek();
                addSpaceAfter = true;
                if (next instanceof TextNode && !(nextText = ((TextNode)next).getWholeText()).isEmpty() && Character.isWhitespace(nextText.charAt(0))) {
                    addSpaceAfter = false;
                }
            }
        }
        if (!text.isEmpty()) {
            int pos;
            for (pos = text.length() - 1; pos >= 0 && Character.isWhitespace(text.charAt(pos)); --pos) {
            }
            if (++pos > 0) {
                if (prefixBefore != null) {
                    out.append((CharSequence)prefixBefore);
                }
                if (addSpaceBefore) {
                    out.append(' ');
                }
                text = text.substring(0, pos);
                out.append(wrapText);
                out.append((CharSequence)text);
                out.append(wrapText);
                if (appendAfter != null) {
                    out.append((CharSequence)appendAfter);
                }
                if (addSpaceAfter) {
                    out.append(' ');
                }
            }
        }
    }

    private String processTextNodes(Node node) {
        Node child;
        this.pushState(node);
        FormattingAppendableImpl out = new FormattingAppendableImpl(0);
        while ((child = this.peek()) != null) {
            if (child instanceof TextNode) {
                String text = ((TextNode)child).getWholeText();
                out.append((CharSequence)this.prepareText(text));
                this.skip();
                continue;
            }
            if (!(child instanceof Element)) continue;
            this.processElement((FormattingAppendable)out, child);
        }
        this.popState();
        return out.getText();
    }

    private boolean processA(FormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("href")) {
            String title;
            String text = Utils.removeStart((String)Utils.removeEnd((String)this.processTextNodes((Node)element), (char)'\n'), (char)'\n');
            String href = element.attr("href");
            String string = title = element.hasAttr("title") ? element.attr("title") : null;
            if (!text.isEmpty() || !href.contains("#")) {
                if (this.myOptions.extractAutoLinks && href.equals(text) && (title == null || title.isEmpty())) {
                    if (this.myOptions.wrapAutoLinks) {
                        out.append('<');
                    }
                    out.append((CharSequence)text);
                    if (this.myOptions.wrapAutoLinks) {
                        out.append('>');
                    }
                } else {
                    out.append('[');
                    out.append((CharSequence)text);
                    out.append(']');
                    out.append('(').append((CharSequence)href);
                    if (title != null) {
                        out.append((CharSequence)" \"").append((CharSequence)element.attr("title").replace("\n", this.myOptions.eolInTitleAttribute).replace("\"", "\\\"")).append('\"');
                    }
                    out.append((CharSequence)")");
                }
            } else if (!text.isEmpty()) {
                out.append((CharSequence)text);
            }
        } else {
            this.processTextNodes(out, (Node)element);
        }
        return true;
    }

    private boolean processBr(FormattingAppendable out, Element element) {
        this.skip();
        if (out.isPreFormatted()) {
            out.append('\n');
        } else {
            int options = out.getOptions();
            out.setOptions(options & 0xFFFFFFF9);
            out.repeat(' ', 2).line();
            out.setOptions(options);
        }
        return true;
    }

    private boolean processAbbr(FormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("title")) {
            String text = this.processTextNodes((Node)element).trim();
            this.myAbbreviations.put(text, element.attr("title"));
        }
        return true;
    }

    private boolean processAside(FormattingAppendable out, Element element) {
        this.skip();
        out.pushPrefix();
        out.addPrefix((CharSequence)"| ");
        this.processHtmlTree(out, (Node)element);
        out.popPrefix();
        return true;
    }

    private boolean processBlockquote(FormattingAppendable out, Element element) {
        this.skip();
        out.pushPrefix();
        out.addPrefix((CharSequence)"> ");
        this.processHtmlTree(out, (Node)element);
        out.popPrefix();
        return true;
    }

    private boolean processCode(FormattingAppendable out, Element element) {
        this.skip();
        BasedSequence text = SubSequence.of((CharSequence)element.ownText());
        int backTickCount = this.getMaxRepeatedChars((CharSequence)text, '`', 1);
        RepeatedCharSequence backTicks = RepeatedCharSequence.of((CharSequence)"`", (int)backTickCount);
        this.processTextNodes(out, (Node)element, (CharSequence)backTicks);
        return true;
    }

    private int getMaxRepeatedChars(CharSequence text, char c, int minCount) {
        int pos;
        BasedSequence chars = BasedSequenceImpl.of((CharSequence)text);
        int lastPos = 0;
        while (lastPos < chars.length() && (pos = chars.indexOf(c, lastPos)) >= 0) {
            int count = chars.countChars(c, pos);
            if (minCount <= count) {
                minCount = count + 1;
            }
            lastPos = pos + count;
        }
        return minCount;
    }

    private boolean processDel(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "~~", true);
        }
        return true;
    }

    private boolean processEmphasis(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "*", true);
        }
        return true;
    }

    private boolean processHeading(FormattingAppendable out, Element element) {
        String headingText;
        int level;
        this.skip();
        TagParam tagParam = this.getTagParam((Node)element);
        if (tagParam != null && (level = ((Integer)tagParam.param).intValue()) >= 1 && level <= 6 && !(headingText = this.processTextNodes((Node)element).trim()).isEmpty()) {
            out.blankLine();
            if (this.myOptions.setextHeadings && level <= 2) {
                out.append((CharSequence)headingText);
                out.line().repeat(level == 1 ? (char)'=' : '-', Utils.minLimit((int)headingText.length(), (int[])new int[]{this.myOptions.minSetextHeadingMarkerLength}));
            } else {
                out.repeat('#', level).append(' ');
                out.append((CharSequence)headingText);
            }
            out.blankLine();
        }
        return true;
    }

    private boolean processHr(FormattingAppendable out, Element element) {
        this.skip();
        out.blankLine().append((CharSequence)this.myOptions.thematicBreak).blankLine();
        return true;
    }

    private boolean processImg(FormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("src")) {
            String src = element.attr("src");
            EmojiCheatSheet.EmojiShortcut shortcut = EmojiCheatSheet.getImageShortcut((String)src);
            if (shortcut != null) {
                out.append(':').append((CharSequence)shortcut.name).append(':');
            } else {
                int eol;
                out.append((CharSequence)"![");
                if (element.hasAttr("alt")) {
                    out.append((CharSequence)element.attr("alt"));
                }
                out.append(']');
                out.append('(');
                int pos = src.indexOf(63);
                int n = eol = pos < 0 ? pos : src.indexOf("%0A", pos);
                if (pos > 0 && eol > 0) {
                    out.append((CharSequence)src, 0, pos + 1);
                    String decoded = Utils.urlDecode((String)src.substring(pos + 1).replace("+", "%2B"), (String)"UTF8");
                    out.line().append((CharSequence)decoded);
                } else {
                    out.append((CharSequence)src);
                }
                if (element.hasAttr("title")) {
                    out.append((CharSequence)" \"").append((CharSequence)element.attr("title").replace("\n", this.myOptions.eolInTitleAttribute).replace("\"", "\\\"")).append('\"');
                }
                out.append((CharSequence)")");
            }
        }
        return true;
    }

    private boolean processP(FormattingAppendable out, Element element) {
        this.skip();
        boolean isItemParagraph = false;
        boolean isDefinitionItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
            isDefinitionItemParagraph = tagName.equalsIgnoreCase("dd");
        }
        out.blankLineIf(!isItemParagraph && !isDefinitionItemParagraph);
        this.processTextNodes(out, (Node)element);
        out.blankLineIf(isItemParagraph || isDefinitionItemParagraph).line();
        return true;
    }

    private boolean processInput(FormattingAppendable out, Element element) {
        boolean isItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
        }
        if (isItemParagraph && element.hasAttr("type") && "checkbox".equalsIgnoreCase(element.attr("type"))) {
            this.skip();
            if (element.hasAttr("checked")) {
                out.append((CharSequence)"[x] ");
            } else {
                out.append((CharSequence)"[ ] ");
            }
            return true;
        }
        return false;
    }

    private boolean processIns(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "++", true);
        }
        return true;
    }

    private boolean processStrong(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "**", true);
        }
        return true;
    }

    private boolean processSub(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "~", true);
        }
        return true;
    }

    private boolean processSup(FormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (Node)element, "^", true);
        }
        return true;
    }

    private boolean processSvg(FormattingAppendable out, Element element) {
        if (element.hasClass("octicon")) {
            this.skip();
            return true;
        }
        return false;
    }

    private boolean processPre(FormattingAppendable out, Element element) {
        String text;
        this.pushState((Node)element);
        Node next = this.peek();
        boolean hadCode = false;
        String className = "";
        if (next != null && next.nodeName().equalsIgnoreCase("code")) {
            hadCode = true;
            Element code = (Element)next;
            FormattingAppendableImpl preText = new FormattingAppendableImpl(out.getOptions() & 0xFFFFFFF9);
            preText.openPreFormatted(false);
            this.processHtmlTree((FormattingAppendable)preText, (Node)code);
            preText.closePreFormatted();
            text = preText.getText(2);
            this.skip(1);
            className = Utils.removeStart((String)code.className(), (String)"language-");
        } else {
            FormattingAppendableImpl preText = new FormattingAppendableImpl(out.getOptions() & 0xFFFFFFF9);
            preText.openPreFormatted(false);
            this.processHtmlTree((FormattingAppendable)preText, (Node)element);
            preText.closePreFormatted();
            text = preText.getText(2);
        }
        int backTickCount = this.getMaxRepeatedChars(text, '`', 3);
        RepeatedCharSequence backTicks = RepeatedCharSequence.of((CharSequence)"`", (int)backTickCount);
        if (!className.isEmpty() || text.trim().isEmpty() || !hadCode) {
            out.blankLine().append((CharSequence)backTicks);
            if (!className.isEmpty()) {
                out.append((CharSequence)className);
            }
            out.line();
            out.openPreFormatted(true);
            out.append((CharSequence)(text.isEmpty() ? "\n" : text));
            out.closePreFormatted();
            out.line().append((CharSequence)backTicks).blankLine();
        } else {
            out.blankLine();
            out.pushPrefix();
            out.addPrefix((CharSequence)this.myOptions.codeIndent);
            out.openPreFormatted(true);
            out.append((CharSequence)(text.isEmpty() ? "\n" : text));
            out.closePreFormatted();
            out.blankLine();
            out.popPrefix();
        }
        this.popState();
        this.next();
        return true;
    }

    private void processListItem(FormattingAppendable out, Element item, ListState listState) {
        this.skip();
        this.pushState((Node)item);
        ++listState.itemCount;
        String itemPrefix = listState.getItemPrefix(this.myOptions);
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of((CharSequence)" ", (int)(this.myOptions.listContentIndent ? itemPrefix.length() : 4));
        out.line().append((CharSequence)itemPrefix);
        out.pushPrefix();
        out.addPrefix((CharSequence)childPrefix);
        int offset = out.offset();
        this.processHtmlTree(out, (Node)item);
        if (offset == out.offset()) {
            out.append(' ');
            out.flushWhitespaces();
        }
        out.line();
        out.popPrefix();
        this.popState();
    }

    private boolean hasListItemParent(Element element) {
        for (Element parent = element.parent(); parent != null; parent = parent.parent()) {
            if (!parent.tagName().equalsIgnoreCase("li")) continue;
            return true;
        }
        return false;
    }

    private boolean processList(FormattingAppendable out, Element element, boolean isNumbered, boolean isFakeList) {
        Node item;
        Element previousElementSibling;
        String tag;
        if (!isFakeList) {
            this.skip();
            this.pushState((Node)element);
        }
        String string = tag = (previousElementSibling = element.previousElementSibling()) == null ? null : previousElementSibling.tagName().toUpperCase();
        if (tag != null && tag.equals(element.tagName().toUpperCase()) && (tag.equals("UL") || tag.equals("OL"))) {
            if (this.myOptions.listsEndOnDoubleBlank) {
                out.blankLine(2);
            } else {
                out.line().append((CharSequence)"<!-- -->").line();
            }
        }
        ListState listState = new ListState(isNumbered);
        block4: while ((item = this.peek()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case LI: {
                        this.processListItem(out, (Element)item, listState);
                        continue block4;
                    }
                    case P: {
                        this.processListItem(out, (Element)item, listState);
                        continue block4;
                    }
                }
                this.skip();
                continue;
            }
            this.processWrapped(out, item, true);
        }
        out.blankLine();
        if (!isFakeList) {
            this.popState();
        }
        return true;
    }

    private boolean processOl(FormattingAppendable out, Element element) {
        return this.processList(out, element, true, false);
    }

    private boolean processUl(FormattingAppendable out, Element element) {
        return this.processList(out, element, false, false);
    }

    private void processDefinition(FormattingAppendable out, Element item) {
        this.skip();
        this.pushState((Node)item);
        int options = out.getOptions();
        Elements children = item.children();
        boolean firstIsPara = false;
        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("p")) {
            out.blankLine();
            firstIsPara = true;
        }
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of((CharSequence)" ", (int)(this.myOptions.listContentIndent ? this.myOptions.definitionMarkerSpaces + 1 : 4));
        out.line().setOptions(options & 0xFFFFFFFD);
        out.append(':').repeat(' ', this.myOptions.definitionMarkerSpaces);
        out.pushPrefix();
        out.addPrefix((CharSequence)childPrefix);
        out.setOptions(options);
        if (firstIsPara) {
            this.processHtmlTree(out, (Node)item);
        } else {
            this.processTextNodes(out, (Node)item);
        }
        out.popPrefix();
        this.popState();
    }

    private boolean processDl(FormattingAppendable out, Element element) {
        Node item;
        this.skip();
        this.pushState((Node)element);
        boolean lastWasDefinition = true;
        boolean firstItem = true;
        block4: while ((item = this.next()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case DT: {
                        out.blankLineIf(lastWasDefinition).lineIf(!firstItem);
                        this.processTextNodes(out, item);
                        out.line();
                        lastWasDefinition = false;
                        firstItem = false;
                        continue block4;
                    }
                    case DD: {
                        this.processDefinition(out, (Element)item);
                        lastWasDefinition = true;
                        firstItem = false;
                        continue block4;
                    }
                }
                continue;
            }
            this.processWrapped(out, item, true);
        }
        this.popState();
        return true;
    }

    private boolean processDiv(FormattingAppendable out, Element element) {
        this.skip();
        this.processHtmlTree(out, (Node)element);
        return true;
    }

    private boolean processUnwrapped(FormattingAppendable out, Node element) {
        this.skip();
        this.processHtmlTree(out, element);
        return true;
    }

    private boolean processSpan(FormattingAppendable out, Element element) {
        String style;
        if (element.hasAttr("style") && (style = element.attr("style")).equals("mso-list:Ignore")) {
            this.skip();
            String text = this.processTextNodes((Node)element);
            if (NUMERIC_DOT_LIST.matcher(text).matches()) {
                out.append((CharSequence)text).append(' ');
            } else if (NUMERIC_PAREN_LIST.matcher(text).matches()) {
                if (this.myOptions.dotOnlyNumericLists) {
                    out.append((CharSequence)text, 0, text.length() - 1).append((CharSequence)". ");
                } else {
                    out.append((CharSequence)text).append(' ');
                }
            } else if (NON_NUMERIC_DOT_LIST.matcher(text).matches()) {
                out.append((CharSequence)"1. ");
            } else if (NON_NUMERIC_PAREN_LIST.matcher(text).matches()) {
                if (this.myOptions.dotOnlyNumericLists) {
                    out.append((CharSequence)"1. ");
                } else {
                    out.append((CharSequence)"1) ");
                }
            } else if (text.equals("\u00b7")) {
                out.append((CharSequence)"* ");
            } else {
                out.append((CharSequence)"* ").append((CharSequence)text);
            }
            return true;
        }
        this.skip();
        this.processHtmlTree(out, (Node)element);
        return true;
    }

    private boolean processEmoji(FormattingAppendable out, Element element) {
        if (element.tagName().equalsIgnoreCase("g-emoji")) {
            EmojiCheatSheet.EmojiShortcut shortcut;
            if (element.hasAttr("alias")) {
                this.skip();
                out.append(':').append((CharSequence)element.attr("alias")).append(':');
                return true;
            }
            if (element.hasAttr("fallback-src") && (shortcut = EmojiCheatSheet.getImageShortcut((String)element.attr("fallback-src"))) != null) {
                this.skip();
                out.append(':').append((CharSequence)shortcut.name).append(':');
                return true;
            }
        }
        return false;
    }

    private boolean processComment(FormattingAppendable out, Comment element) {
        this.skip();
        if (this.myOptions.renderComments) {
            out.append((CharSequence)"<!--").append((CharSequence)element.getData()).append((CharSequence)"-->");
        }
        return true;
    }

    private TagParam getTagParam(Node node) {
        return ourTagProcessors.get(node.nodeName().toLowerCase());
    }

    private boolean processTable(FormattingAppendable out, Element table) {
        Node item;
        Table oldTable = this.myTable;
        this.skip();
        this.pushState((Node)table);
        this.myTable = new Table(this.myOptions.tableOptions);
        while ((item = this.next()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam == null) continue;
            switch (tagParam.tagType) {
                case CAPTION: {
                    this.processTableCaption(out, (Element)item);
                    break;
                }
                case TBODY: {
                    this.myTable.setHeading(false);
                    this.processTableSection(out, (Element)item);
                    break;
                }
                case THEAD: {
                    this.myTable.setHeading(true);
                    this.processTableSection(out, (Element)item);
                    break;
                }
                case TR: {
                    Element tableRow = (Element)item;
                    Elements children = tableRow.children();
                    this.myTable.setHeading(!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th"));
                    this.processTableRow(out, (Element)item);
                }
            }
        }
        this.myTable.finalizeTable();
        int sepColumns = this.myTable.getMaxColumns();
        if (sepColumns > 0) {
            out.blankLine();
            this.myTable.appendTable(out);
            out.blankLine();
        }
        this.myTable = oldTable;
        this.popState();
        return true;
    }

    private void processTableSection(FormattingAppendable out, Element element) {
        Node node;
        this.pushState((Node)element);
        while ((node = this.next()) != null) {
            TagParam tagParam = this.getTagParam(node);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case TR: {
                        Element tableRow = (Element)node;
                        Elements children = tableRow.children();
                        boolean wasHeading = this.myTable.isHeading();
                        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th")) {
                            this.myTable.setHeading(true);
                        }
                        this.processTableRow(out, tableRow);
                        this.myTable.setHeading(wasHeading);
                        break;
                    }
                }
                continue;
            }
            this.processWrapped(out, (Node)element, true);
        }
        this.popState();
    }

    private void processTableRow(FormattingAppendable out, Element element) {
        Node node;
        this.pushState((Node)element);
        while ((node = this.next()) != null) {
            TagParam tagParam = this.getTagParam(node);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case TH: {
                        this.processTableCell(out, (Element)node);
                        break;
                    }
                    case TD: {
                        this.processTableCell(out, (Element)node);
                    }
                }
                continue;
            }
            this.processWrapped(out, (Node)element, true);
        }
        this.myTable.nextRow();
        this.popState();
    }

    private void processTableCaption(FormattingAppendable out, Element element) {
        this.myTable.setCaption((CharSequence)this.processTextNodes((Node)element).trim());
    }

    private void processTableCell(FormattingAppendable out, Element element) {
        String cellText = this.processTextNodes((Node)element).trim().replaceAll("\\s*\n\\s*", " ");
        int colSpan = 1;
        int rowSpan = 1;
        CellAlignment alignment = null;
        if (element.hasAttr("colSpan")) {
            try {
                colSpan = Integer.parseInt(element.attr("colSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("rowSpan")) {
            try {
                rowSpan = Integer.parseInt(element.attr("rowSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("align")) {
            alignment = CellAlignment.getAlignment((String)element.attr("align"));
        } else {
            Set classNames = element.classNames();
            if (!classNames.isEmpty()) {
                for (String clazz : classNames) {
                    CellAlignment cellAlignment = this.myOptions.tableCellAlignmentMap.get(clazz);
                    if (cellAlignment == null) continue;
                    alignment = cellAlignment;
                    break;
                }
                if (alignment == null) {
                    for (Object key : this.myOptions.tableCellAlignmentMap.keySet()) {
                        if (!(key instanceof Pattern)) continue;
                        Pattern pattern = (Pattern)key;
                        for (String clazz : classNames) {
                            if (!pattern.matcher(clazz).find()) continue;
                            alignment = this.myOptions.tableCellAlignmentMap.get(key);
                            break;
                        }
                        if (alignment == null) continue;
                        break;
                    }
                }
            }
        }
        this.myTable.addCell(new Table.TableCell((CharSequence)SubSequence.NULL, (CharSequence)cellText, (CharSequence)BasedSequence.NULL, rowSpan, colSpan, alignment));
    }

    private void pushState(Node parent) {
        this.myStateStack.push(this.myState);
        this.myState = new State(parent);
    }

    private void popState() {
        if (this.myStateStack.isEmpty()) {
            throw new IllegalStateException("popState with an empty stack");
        }
        this.myState = this.myStateStack.pop();
    }

    private Node peek() {
        if (this.myState.myIndex < this.myState.myElements.size()) {
            return this.myState.myElements.get(this.myState.myIndex);
        }
        return null;
    }

    private Node peek(int skip) {
        if (this.myState.myIndex + skip >= 0 && this.myState.myIndex + skip < this.myState.myElements.size()) {
            return this.myState.myElements.get(this.myState.myIndex + skip);
        }
        return null;
    }

    private Node next() {
        Node next = this.peek();
        if (next != null) {
            ++this.myState.myIndex;
        }
        return next;
    }

    private void skip() {
        Node next = this.peek();
        if (next != null) {
            ++this.myState.myIndex;
        }
    }

    private Node next(int skip) {
        if (skip > 0) {
            Node next = this.peek(skip - 1);
            if (next != null) {
                this.myState.myIndex += skip;
            }
            return next;
        }
        return this.peek();
    }

    private void skip(int skip) {
        Node next;
        if (skip > 0 && (next = this.peek(skip - 1)) != null) {
            this.myState.myIndex += skip;
        }
    }

    static {
        tableCellAlignments.put(Pattern.compile("\\bleft\\b"), CellAlignment.LEFT);
        tableCellAlignments.put(Pattern.compile("\\bcenter\\b"), CellAlignment.CENTER);
        tableCellAlignments.put(Pattern.compile("\\bright\\b"), CellAlignment.RIGHT);
        tableCellAlignments.put("text-left", CellAlignment.LEFT);
        tableCellAlignments.put("text-center", CellAlignment.CENTER);
        tableCellAlignments.put("text-right", CellAlignment.RIGHT);
        typographicMap = new HashMap<String, String>();
        typographicMap.put("\u201c", "\"");
        typographicMap.put("\u201d", "\"");
        typographicMap.put("&ldquo;", "\"");
        typographicMap.put("&rdquo;", "\"");
        typographicMap.put("\u2018", "'");
        typographicMap.put("\u2019", "'");
        typographicMap.put("&lsquo;", "'");
        typographicMap.put("&rsquo;", "'");
        typographicMap.put("&apos;", "'");
        typographicMap.put("\u00ab", "<<");
        typographicMap.put("&laquo;", "<<");
        typographicMap.put("\u00bb", ">>");
        typographicMap.put("&raquo;", ">>");
        typographicMap.put("\u2026", "...");
        typographicMap.put("&hellip;", "...");
        typographicMap.put("\u2013", "--");
        typographicMap.put("&endash;", "--");
        typographicMap.put("\u2014", "---");
        typographicMap.put("&emdash;", "---");
        NUMERIC_DOT_LIST = Pattern.compile("^\\d+\\.$");
        NUMERIC_PAREN_LIST = Pattern.compile("^\\d+\\)$");
        NON_NUMERIC_DOT_LIST = Pattern.compile("^(?:(?:" + RomanNumeral.ROMAN_NUMERAL.pattern() + ")|(?:" + RomanNumeral.LOWERCASE_ROMAN_NUMERAL.pattern() + ")|[a-z]+|[A-Z]+)\\.$");
        NON_NUMERIC_PAREN_LIST = Pattern.compile("^(?:[a-z]+|[A-Z]+)\\)$");
        TABLE_CELL_ALIGNMENT_MAP = new DataKey("TABLE_CELL_ALIGNMENT_MAP", tableCellAlignments);
        ourTagProcessors = new HashMap<String, TagParam>();
        ourTagProcessors.put("a", TagParam.tag(TagType.A, null));
        ourTagProcessors.put("abbr", TagParam.tag(TagType.ABBR, null));
        ourTagProcessors.put("aside", TagParam.tag(TagType.ASIDE, null));
        ourTagProcessors.put("br", TagParam.tag(TagType.BR, null));
        ourTagProcessors.put("blockquote", TagParam.tag(TagType.BLOCKQUOTE, null));
        ourTagProcessors.put("caption", TagParam.tag(TagType.CAPTION, null));
        ourTagProcessors.put("code", TagParam.tag(TagType.CODE, null));
        ourTagProcessors.put("del", TagParam.tag(TagType.DEL, null));
        ourTagProcessors.put("div", TagParam.tag(TagType.DIV, null));
        ourTagProcessors.put("dd", TagParam.tag(TagType.DD, null));
        ourTagProcessors.put("dl", TagParam.tag(TagType.DL, null));
        ourTagProcessors.put("dt", TagParam.tag(TagType.DT, null));
        ourTagProcessors.put("i", TagParam.tag(TagType._EMPHASIS, null));
        ourTagProcessors.put("em", TagParam.tag(TagType._EMPHASIS, null));
        ourTagProcessors.put("h1", TagParam.tag(TagType._HEADING, 1));
        ourTagProcessors.put("h2", TagParam.tag(TagType._HEADING, 2));
        ourTagProcessors.put("h3", TagParam.tag(TagType._HEADING, 3));
        ourTagProcessors.put("h4", TagParam.tag(TagType._HEADING, 4));
        ourTagProcessors.put("h5", TagParam.tag(TagType._HEADING, 5));
        ourTagProcessors.put("h6", TagParam.tag(TagType._HEADING, 6));
        ourTagProcessors.put("hr", TagParam.tag(TagType.HR, null));
        ourTagProcessors.put("img", TagParam.tag(TagType.IMG, null));
        ourTagProcessors.put("input", TagParam.tag(TagType.INPUT, null));
        ourTagProcessors.put("ins", TagParam.tag(TagType.INS, null));
        ourTagProcessors.put("u", TagParam.tag(TagType.INS, null));
        ourTagProcessors.put("li", TagParam.tag(TagType.LI, null));
        ourTagProcessors.put("ol", TagParam.tag(TagType.OL, null));
        ourTagProcessors.put("p", TagParam.tag(TagType.P, null));
        ourTagProcessors.put("pre", TagParam.tag(TagType.PRE, null));
        ourTagProcessors.put("b", TagParam.tag(TagType._STRONG_EMPHASIS, null));
        ourTagProcessors.put("strong", TagParam.tag(TagType._STRONG_EMPHASIS, null));
        ourTagProcessors.put("sub", TagParam.tag(TagType.SUB, null));
        ourTagProcessors.put("sup", TagParam.tag(TagType.SUP, null));
        ourTagProcessors.put("svg", TagParam.tag(TagType.SVG, null));
        ourTagProcessors.put("table", TagParam.tag(TagType.TABLE, null));
        ourTagProcessors.put("tbody", TagParam.tag(TagType.TBODY, null));
        ourTagProcessors.put("td", TagParam.tag(TagType.TD, null));
        ourTagProcessors.put("th", TagParam.tag(TagType.TH, null));
        ourTagProcessors.put("thead", TagParam.tag(TagType.THEAD, null));
        ourTagProcessors.put("tr", TagParam.tag(TagType.TR, null));
        ourTagProcessors.put("ul", TagParam.tag(TagType.UL, null));
        ourTagProcessors.put("#comment", TagParam.tag(TagType._COMMENT, null));
        ourTagProcessors.put("#text", TagParam.tag(TagType._TEXT, null));
        ourTagProcessors.put("kbd", TagParam.tag(TagType._WRAPPED, false));
        ourTagProcessors.put("var", TagParam.tag(TagType._WRAPPED, false));
        ourTagProcessors.put("article", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("address", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("article", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("frameset", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("section", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("span", TagParam.tag(TagType._SPAN, null));
        ourTagProcessors.put("small", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("iframe", TagParam.tag(TagType._UNWRAPPED, null));
    }

    private static class TagParam {
        final TagType tagType;
        final Object param;

        TagParam(TagType tagType, Object param) {
            this.tagType = tagType;
            this.param = param;
        }

        static TagParam tag(TagType tagType, Object param) {
            return new TagParam(tagType, param);
        }
    }

    static enum TagType {
        A,
        ABBR,
        ASIDE,
        BR,
        BLOCKQUOTE,
        CAPTION,
        CODE,
        DEL,
        DIV,
        DL,
        DD,
        DT,
        _EMPHASIS,
        HR,
        IMG,
        INPUT,
        INS,
        LI,
        OL,
        P,
        PRE,
        _STRONG_EMPHASIS,
        SUB,
        SUP,
        SVG,
        TABLE,
        TBODY,
        TD,
        TH,
        THEAD,
        TR,
        UL,
        _HEADING,
        _UNWRAPPED,
        _SPAN,
        _WRAPPED,
        _COMMENT,
        _TEXT;

    }

    private static class ListState {
        boolean isNumbered;
        int itemCount;

        ListState(boolean isNumbered) {
            this.isNumbered = isNumbered;
            this.itemCount = 0;
        }

        String getItemPrefix(HtmlParserOptions options) {
            if (this.isNumbered) {
                return String.format("%d%c ", this.itemCount, Character.valueOf(options.orderedListDelimiter));
            }
            return String.format("%c ", Character.valueOf(options.unorderedListDelimiter));
        }
    }

    private static class State {
        Node myParent;
        List<Node> myElements;
        int myIndex;

        State(Node parent) {
            this.myParent = parent;
            this.myElements = parent.childNodes();
            this.myIndex = 0;
        }

        public String toString() {
            return "State{myParent=" + this.myParent + ", myElements=" + this.myElements + ", myIndex=" + this.myIndex + '}';
        }
    }
}

