/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.internal.EmojiOptions;
import com.vladsch.flexmark.ext.emoji.internal.EmojiResolvedShortcut;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class EmojiNodeRenderer
implements NodeRenderer {
    final EmojiOptions myOptions;

    public EmojiNodeRenderer(DataHolder options) {
        this.myOptions = new EmojiOptions(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<Emoji>(Emoji.class, new CustomNodeRenderer<Emoji>(){

            @Override
            public void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
                EmojiNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
        EmojiResolvedShortcut shortcut = EmojiResolvedShortcut.getEmojiText(node, this.myOptions.useShortcutType, this.myOptions.useImageType, this.myOptions.rootImagePath);
        if (shortcut.emoji == null || shortcut.emojiText == null) {
            html.text(":");
            context.renderChildren(node);
            html.text(":");
        } else if (shortcut.isUnicode) {
            html.text(shortcut.emojiText);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, shortcut.emojiText, null);
            html.attr("src", resolvedLink.getUrl());
            html.attr("alt", shortcut.alt);
            if (!this.myOptions.attrImageSize.isEmpty()) {
                ((HtmlWriter)html.attr("height", this.myOptions.attrImageSize)).attr("width", this.myOptions.attrImageSize);
            }
            if (!this.myOptions.attrAlign.isEmpty()) {
                html.attr("align", this.myOptions.attrAlign);
            }
            if (!this.myOptions.attrImageClass.isEmpty()) {
                html.attr("class", this.myOptions.attrImageClass);
            }
            html.withAttr(resolvedLink);
            html.tagVoid("img");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new EmojiNodeRenderer(options);
        }
    }
}

