/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableJiraRenderer
implements NodeRenderer {
    public TableJiraRenderer(DataHolder options) {
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<TableBlock>(TableBlock.class, new CustomNodeRenderer<TableBlock>(){

            @Override
            public void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TableHead>(TableHead.class, new CustomNodeRenderer<TableHead>(){

            @Override
            public void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TableSeparator>(TableSeparator.class, new CustomNodeRenderer<TableSeparator>(){

            @Override
            public void render(TableSeparator node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TableBody>(TableBody.class, new CustomNodeRenderer<TableBody>(){

            @Override
            public void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TableRow>(TableRow.class, new CustomNodeRenderer<TableRow>(){

            @Override
            public void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TableCell>(TableCell.class, new CustomNodeRenderer<TableCell>(){

            @Override
            public void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
        html.blankLine();
    }

    private void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    private void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
        if (node.getParent() instanceof TableHead) {
            ((HtmlWriter)html.line()).raw("||");
        } else if (node.getParent() instanceof TableBody) {
            ((HtmlWriter)html.line()).raw("|");
        }
        context.renderChildren(node);
        html.line();
    }

    private void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
        if (node.getParent().getParent() instanceof TableHead) {
            html.raw("||");
        } else if (node.getParent().getParent() instanceof TableBody) {
            html.raw("|");
        }
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new TableJiraRenderer(options);
        }
    }
}

