/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.Paired;
import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.MapEntry;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class OrderedMultiMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    private final OrderedSet<K> myKeySet;
    private final OrderedSet<V> myValueSet;
    private final CollectionHost<Paired<K, V>> myHost;
    private boolean myInKeyUpdate;
    private boolean myInValueUpdate;
    private Indexed<Map.Entry<K, V>> myIndexedProxy;

    public OrderedMultiMap() {
        this(0, null);
    }

    public OrderedMultiMap(int capacity) {
        this(capacity, null);
    }

    public OrderedMultiMap(CollectionHost<Paired<K, V>> host) {
        this(0, host);
    }

    public OrderedMultiMap(int capacity, CollectionHost<Paired<K, V>> host) {
        this.myHost = host;
        this.myIndexedProxy = null;
        this.myValueSet = new OrderedSet(capacity, new CollectionHost<V>(){

            @Override
            public void adding(int index, V v, Object k) {
                OrderedMultiMap.this.addingValue(index, v, k);
            }

            @Override
            public Object removing(int index, V v) {
                return OrderedMultiMap.this.removingValue(index, v);
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addingNullValue(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.myInKeyUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
        this.myKeySet = new OrderedSet(capacity, new CollectionHost<K>(){

            @Override
            public void adding(int index, K k, Object v) {
                OrderedMultiMap.this.addingKey(index, k, v);
            }

            @Override
            public Object removing(int index, K k) {
                return OrderedMultiMap.this.removingKey(index, k);
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addingNullKey(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.myInValueUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
    }

    public Indexed<Map.Entry<K, V>> getIndexedProxy() {
        if (this.myIndexedProxy != null) {
            return this.myIndexedProxy;
        }
        this.myIndexedProxy = new Indexed<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> get(int index) {
                return OrderedMultiMap.this.getEntry(index);
            }

            @Override
            public void set(int index, Map.Entry<K, V> item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAt(int index) {
                OrderedMultiMap.this.removeEntryIndex(index);
            }

            @Override
            public int size() {
                return OrderedMultiMap.this.size();
            }

            @Override
            public int modificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        };
        return this.myIndexedProxy;
    }

    private Map.Entry<K, V> getEntry(int index) {
        return new MapEntry<K, V>(this.myKeySet.getValueOrNull(index), this.myValueSet.getValueOrNull(index));
    }

    public int getModificationCount() {
        return (int)((long)this.myKeySet.getModificationCount() + (long)this.myValueSet.getModificationCount());
    }

    private void addingKey(int index, K k, Object v) {
        assert (!this.myInValueUpdate);
        this.myInValueUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.adding(index, new Pair<K, Object>(k, v), null);
        }
        if (v == null) {
            this.myValueSet.addNulls(index);
        } else {
            this.myValueSet.add(v);
        }
        this.myInValueUpdate = false;
    }

    private void addingNullKey(int index) {
        assert (!this.myInValueUpdate);
        this.myInValueUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.addingNulls(index);
        }
        while (this.valueSet().size() <= index) {
            this.myValueSet.add(null);
        }
        this.myInValueUpdate = false;
    }

    private Object removingKey(int index, K k) {
        assert (!this.myInValueUpdate);
        this.myInValueUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.removing(index, new Pair<K, Object>(k, null));
        }
        Object r = this.myValueSet.removeIndexHosted(index);
        this.myInValueUpdate = false;
        return r;
    }

    private void addingValue(int index, V v, Object k) {
        assert (!this.myInKeyUpdate);
        this.myInKeyUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.adding(index, new Pair<Object, V>(k, v), null);
        }
        if (k == null) {
            this.myKeySet.addNulls(index);
        } else {
            this.myKeySet.add(k);
        }
        this.myInKeyUpdate = false;
    }

    private void addingNullValue(int index) {
        assert (!this.myInKeyUpdate);
        this.myInKeyUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.addingNulls(index);
        }
        while (this.myKeySet.size() <= index) {
            this.myKeySet.add(null);
        }
        this.myInKeyUpdate = false;
    }

    private Object removingValue(int index, V v) {
        assert (!this.myInKeyUpdate);
        this.myInKeyUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.removing(index, new Pair<Object, V>(null, v));
        }
        Object r = this.myKeySet.removeIndexHosted(index);
        this.myInKeyUpdate = false;
        return r;
    }

    @Override
    public int size() {
        return this.myKeySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeySet.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.myKeySet.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        int index = this.myValueSet.indexOf(o);
        return this.myKeySet.isValidIndex(index);
    }

    @Override
    public V get(Object o) {
        return this.getKeyValue(o);
    }

    public V getKeyValue(Object o) {
        int index = this.myKeySet.indexOf(o);
        return index == -1 ? null : (V)this.myValueSet.getValue(index);
    }

    public K getValueKey(Object o) {
        int index = this.myValueSet.indexOf(o);
        return index == -1 ? null : (K)this.myKeySet.getValue(index);
    }

    @Override
    public V put(K k, V v) {
        return this.putKeyValue(k, v);
    }

    public void addNullEntry(int index) {
        this.myInKeyUpdate = true;
        this.myInValueUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.addingNulls(index);
        }
        this.myKeySet.addNulls(index);
        this.myValueSet.addNulls(index);
        this.myInValueUpdate = false;
        this.myInKeyUpdate = false;
    }

    public boolean putEntry(Map.Entry<K, V> e) {
        return this.addKeyValue(e.getKey(), e.getValue());
    }

    public boolean putKeyValueEntry(Map.Entry<K, V> e) {
        return this.addKeyValue(e.getKey(), e.getValue());
    }

    public boolean putValueKeyEntry(Map.Entry<V, K> e) {
        return this.addKeyValue(e.getValue(), e.getKey());
    }

    public boolean putKeyValuePair(Paired<K, V> e) {
        return this.addKeyValue(e.getFirst(), e.getSecond());
    }

    public boolean putValueKeyPair(Paired<V, K> e) {
        return this.addKeyValue(e.getSecond(), e.getFirst());
    }

    public V putKeyValue(K k, V v) {
        return (V)(!this.addKeyValue(k, v) ? v : null);
    }

    public K putValueKey(V v, K k) {
        return (K)(!this.addKeyValue(k, v) ? k : null);
    }

    private boolean addKeyValue(K k, V v) {
        int keyIndex = this.myKeySet.indexOf(k);
        int valueIndex = this.myValueSet.indexOf(v);
        if (keyIndex == -1 && valueIndex == -1) {
            this.myInKeyUpdate = true;
            this.myInValueUpdate = true;
            if (this.myHost != null && !this.myHost.skipHostUpdate()) {
                this.myHost.adding(this.myKeySet.getValueList().size(), new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.myKeySet.addNull();
            } else {
                this.myKeySet.add(k, v);
            }
            if (k == null) {
                this.myValueSet.addNull();
            } else {
                this.myValueSet.add(v, k);
            }
            this.myInValueUpdate = false;
            this.myInKeyUpdate = false;
            return true;
        }
        if (keyIndex == -1) {
            this.myInKeyUpdate = true;
            this.myInValueUpdate = true;
            if (this.myHost != null && !this.myHost.skipHostUpdate()) {
                this.myHost.adding(valueIndex, new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.myKeySet.removeIndex(valueIndex);
            } else {
                this.myKeySet.setValueAt(valueIndex, k, v);
            }
            this.myInValueUpdate = false;
            this.myInKeyUpdate = false;
            return true;
        }
        if (valueIndex == -1) {
            this.myInKeyUpdate = true;
            this.myInValueUpdate = true;
            if (this.myHost != null && !this.myHost.skipHostUpdate()) {
                this.myHost.adding(keyIndex, new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.myValueSet.removeIndex(valueIndex);
            } else {
                this.myValueSet.setValueAt(keyIndex, v, k);
            }
            this.myInValueUpdate = false;
            this.myInValueUpdate = false;
            return true;
        }
        if (valueIndex != keyIndex) {
            throw new IllegalStateException("keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        return false;
    }

    @Override
    public V remove(Object o) {
        return this.removeKey(o);
    }

    public Map.Entry<K, V> removeEntry(Map.Entry<K, V> e) {
        boolean b = this.removeEntryIndex(-1, e.getKey(), e.getValue());
        return b ? e : null;
    }

    private boolean removeEntryIndex(int index) {
        return this.removeEntryIndex(index, this.myKeySet.getValueOrNull(index), this.myValueSet.getValueOrNull(index));
    }

    private boolean removeEntryIndex(int index, K k, V v) {
        int valueIndex;
        int keyIndex = this.myKeySet.indexOf(k);
        if (keyIndex != (valueIndex = this.myValueSet.indexOf(v))) {
            throw new IllegalStateException("keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        if (index != -1 && keyIndex != index) {
            throw new IllegalStateException("removeEntryIndex " + index + " does not match keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        if (keyIndex != -1) {
            this.myInKeyUpdate = true;
            this.myInValueUpdate = true;
            if (this.myHost != null && !this.myHost.skipHostUpdate()) {
                this.myHost.removing(keyIndex, new Pair<K, V>(k, v));
            }
            this.myKeySet.removeHosted(k);
            this.myValueSet.removeHosted(v);
            this.myInValueUpdate = false;
            this.myInKeyUpdate = false;
            return true;
        }
        return false;
    }

    public V removeKey(Object o) {
        int index;
        this.myInKeyUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate() && (index = this.myKeySet.indexOf(o)) != -1) {
            this.myHost.removing(index, new Pair<Object, Object>(o, (this.myValueSet.isValidIndex(index) ? (Object)this.myValueSet.getValue(index) : null)));
        }
        Object r = this.myKeySet.removeHosted(o);
        this.myInKeyUpdate = false;
        return (V)r;
    }

    public K removeValue(Object o) {
        this.myInValueUpdate = true;
        int index = this.myValueSet.indexOf(o);
        if (this.myHost != null && !this.myHost.skipHostUpdate() && index != -1) {
            this.myHost.removing(index, new Pair<Object, Object>((this.myKeySet.isValidIndex(index) ? (Object)this.myKeySet.getValue(index) : null), o));
        }
        Object r = this.myValueSet.removeHosted(o);
        this.myInValueUpdate = false;
        return (K)r;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllKeyValues(map);
    }

    public void putAllKeyValues(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAllValueKeys(Map<? extends V, ? extends K> map) {
        for (Map.Entry<V, K> entry : map.entrySet()) {
            this.putValueKey(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.myInValueUpdate = true;
        this.myInKeyUpdate = true;
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.clearing();
        }
        this.myKeySet.clear();
        this.myValueSet.clear();
        this.myInKeyUpdate = false;
        this.myInValueUpdate = false;
    }

    @Override
    public OrderedSet<K> keySet() {
        return this.myKeySet;
    }

    @Override
    public Collection<V> values() {
        if (!this.myKeySet.isSparse()) {
            return this.myValueSet;
        }
        ArrayList values = new ArrayList(this.myKeySet.size());
        Iterator iterator = this.myValueSet.iterator();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        return values;
    }

    public OrderedSet<V> valueSet() {
        return this.myValueSet;
    }

    public Collection<K> keys() {
        if (!this.myKeySet.isSparse()) {
            return this.myKeySet;
        }
        ArrayList values = new ArrayList(this.myValueSet.size());
        Iterator iterator = this.myKeySet.iterator();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        return values;
    }

    public K getKey(int index) {
        if (!this.myKeySet.isValidIndex(index)) {
            return null;
        }
        return this.myKeySet.getValueList().get(index);
    }

    public V getValue(int index) {
        if (!this.myValueSet.isValidIndex(index)) {
            return null;
        }
        return this.myValueSet.getValue(index);
    }

    @Override
    public OrderedSet<Map.Entry<K, V>> entrySet() {
        return this.keyValueEntrySet();
    }

    public ReversibleIndexedIterator<V> valueIterator() {
        return this.myValueSet.iterator();
    }

    public ReversibleIndexedIterator<V> reversedValueIterator() {
        return this.myValueSet.reversedIterator();
    }

    public ReversibleIterable<V> valueIterable() {
        return new IndexedIterable(this.myValueSet.getIndexedProxy(), this.myValueSet.indexIterable());
    }

    public ReversibleIterable<V> reversedValueIterable() {
        return new IndexedIterable(this.myValueSet.getIndexedProxy(), this.myValueSet.reversedIndexIterable());
    }

    public ReversibleIndexedIterator<K> keyIterator() {
        return ((OrderedSet)this.keySet()).iterator();
    }

    public ReversibleIndexedIterator<K> reversedKeyIterator() {
        return ((OrderedSet)this.keySet()).reversedIterator();
    }

    public ReversibleIterable<K> keyIterable() {
        return new IndexedIterable(this.myKeySet.getIndexedProxy(), this.myKeySet.indexIterable());
    }

    public ReversibleIterable<K> reversedKeyIterable() {
        return new IndexedIterable(this.myKeySet.getIndexedProxy(), this.myKeySet.reversedIndexIterable());
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> entrySetIterator() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterator(this.getIndexedProxy(), new BitSetIterator(bitSet));
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> reversedEntrySetIterator() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterator(this.getIndexedProxy(), new BitSetIterator(bitSet, true));
    }

    public ReversibleIterable<Map.Entry<K, V>> entrySetIterable() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterable(this.getIndexedProxy(), new BitSetIterable(bitSet));
    }

    public ReversibleIterable<Map.Entry<K, V>> reversedEntrySetIterable() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterable(this.getIndexedProxy(), new BitSetIterable(bitSet));
    }

    private BitSet getKeyValueUnionSet() {
        BitSet bitSet = new BitSet(this.myKeySet.size());
        bitSet.or(this.myKeySet.getValidIndices());
        bitSet.or(this.myValueSet.getValidIndices());
        return bitSet;
    }

    private BitSet getKeyValueIntersectionSet() {
        BitSet bitSet = new BitSet(this.myKeySet.size());
        bitSet.or(this.myKeySet.getValidIndices());
        bitSet.and(this.myValueSet.getValidIndices());
        return bitSet;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySetIterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entrySetIterator();
        while (iterator.hasNext()) {
            consumer.accept((Map.Entry<K, V>)iterator.next());
        }
    }

    public OrderedSet<Map.Entry<K, V>> keyValueEntrySet() {
        this.myInValueUpdate = true;
        this.myInKeyUpdate = true;
        OrderedSet<Map.Entry<K, V>> values = new OrderedSet<Map.Entry<K, V>>(this.myKeySet.size(), new CollectionHost<Map.Entry<K, V>>(){

            @Override
            public void adding(int index, Map.Entry<K, V> entry, Object v) {
                assert (v == null);
                OrderedMultiMap.this.putKeyValue(entry.getKey(), entry.getValue());
            }

            @Override
            public Object removing(int index, Map.Entry<K, V> entry) {
                boolean b = OrderedMultiMap.this.removeEntryIndex(index, entry.getKey(), entry.getValue());
                return b ? entry : null;
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addNullEntry(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.myInKeyUpdate || OrderedMultiMap.this.myInValueUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
        BitSet bitSet = this.getKeyValueUnionSet();
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entrySetIterator();
        while (iterator.hasNext()) {
            values.add((Map.Entry<K, V>)iterator.next());
        }
        this.myInValueUpdate = false;
        this.myInKeyUpdate = false;
        return values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedMultiMap set = (OrderedMultiMap)o;
        if (this.size() != set.size()) {
            return false;
        }
        return ((OrderedSet)this.entrySet()).equals(set.entrySet());
    }

    @Override
    public int hashCode() {
        int result = this.myKeySet.hashCode();
        result = 31 * result + this.myValueSet.hashCode();
        return result;
    }
}

