/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.BiConsumer;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Attributes {
    public static final Attributes EMPTY = new Attributes();
    private LinkedHashMap<String, Attribute> myAttributes;

    public Attributes() {
        this.myAttributes = null;
    }

    public Attributes(Attributes attributes) {
        this.myAttributes = attributes == null || attributes.myAttributes == null ? null : new LinkedHashMap<String, Attribute>(attributes.myAttributes);
    }

    protected LinkedHashMap<String, Attribute> getAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new LinkedHashMap();
        }
        return this.myAttributes;
    }

    public Attribute get(CharSequence key) {
        if (this.myAttributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        return this.myAttributes.get(useKey);
    }

    public String getValue(CharSequence key) {
        if (this.myAttributes == null || key == null || key.length() == 0) {
            return "";
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.myAttributes.get(useKey);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public Attribute replaceValue(Attribute attribute) {
        return this.replaceValue(attribute.getName(), attribute.getValue());
    }

    public Attribute replaceValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.myAttributes == null ? AttributeImpl.of(useKey, value) : ((attribute = this.myAttributes.get(useKey)) != null ? attribute.replaceValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute addValue(Attribute attribute) {
        return this.addValue(attribute.getName(), attribute.getValue());
    }

    public Attributes addValues(Attributes attributes) {
        for (Attribute attribute : attributes.values()) {
            this.addValue(attribute.getName(), attribute.getValue());
        }
        return this;
    }

    public Attribute addValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.myAttributes == null ? AttributeImpl.of(key, value) : ((attribute = this.myAttributes.get(useKey)) != null ? attribute.setValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute removeValue(Attribute attribute) {
        return this.removeValue(attribute.getName(), attribute.getValue());
    }

    public Attribute remove(Attribute attribute) {
        return this.remove(attribute.getName());
    }

    public Attribute removeValue(CharSequence key, CharSequence value) {
        if (this.myAttributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = this.myAttributes.get(useKey);
        Attribute attribute = oldAttribute.removeValue(value);
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public boolean contains(CharSequence key) {
        if (this.myAttributes == null || key == null || key.length() == 0) {
            return false;
        }
        String useKey = String.valueOf(key);
        return this.myAttributes.containsKey(useKey);
    }

    public boolean containsValue(CharSequence key, CharSequence value) {
        if (this.myAttributes == null) {
            return false;
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.myAttributes.get(useKey);
        return attribute != null && attribute.containsValue(value);
    }

    public boolean isEmpty() {
        return this.myAttributes == null || this.myAttributes.isEmpty();
    }

    public void clear() {
        this.myAttributes = null;
    }

    public Set<String> keySet() {
        return this.myAttributes != null ? this.myAttributes.keySet() : Collections.EMPTY_SET;
    }

    public Collection<Attribute> values() {
        return this.myAttributes != null ? this.myAttributes.values() : Collections.EMPTY_LIST;
    }

    public Set<Map.Entry<String, Attribute>> entrySet() {
        return this.myAttributes != null ? this.myAttributes.entrySet() : Collections.EMPTY_SET;
    }

    public void forEach(BiConsumer<String, Attribute> action) {
        if (this.myAttributes != null) {
            for (Map.Entry<String, Attribute> entry : this.myAttributes.entrySet()) {
                action.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public int size() {
        return this.myAttributes == null ? 0 : this.myAttributes.size();
    }

    public Attribute remove(CharSequence key) {
        if (this.myAttributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = this.myAttributes.get(useKey);
        this.myAttributes.remove(useKey);
        return oldAttribute;
    }

    public void replaceValues(Attributes attributes) {
        if (this.myAttributes == null) {
            this.myAttributes = new LinkedHashMap<String, Attribute>(attributes.myAttributes);
        } else {
            this.myAttributes.putAll(attributes.myAttributes);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String attrName : this.keySet()) {
            sb.append(sep).append(attrName);
            Attribute attribute = this.myAttributes.get(attrName);
            if (!attribute.getValue().isEmpty()) {
                sb.append("=").append("\"").append(attribute.getValue().replace("\"", "\\\"")).append("\"");
            }
            sep = " ";
        }
        return "Attributes{" + sb.toString() + '}';
    }
}

