/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="LogstashLayout", category="Core", elementType="layout", printObject=true)
public class LogstashLayout
extends AbstractStringLayout {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Charset charset;
    private final boolean prettyPrintEnabled;
    private final boolean locationInfoEnabled;
    private final boolean stackTraceEnabled;
    private final FastDateFormat dateTimeFormat;
    private final String sourceHost;
    private final ObjectWriter objectWriter;
    private final String rootTemplate;
    private final ObjectNode rootTemplateNode;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private LogstashLayout(Builder builder) {
        super(builder.config, builder.charset, null, null);
        this.charset = builder.charset;
        this.prettyPrintEnabled = builder.prettyPrintEnabled;
        this.locationInfoEnabled = builder.locationInfoEnabled;
        this.stackTraceEnabled = builder.stackTraceEnabled;
        this.dateTimeFormat = LogstashLayout.readDateFormat(builder);
        this.sourceHost = builder.sourceHost;
        this.objectWriter = this.prettyPrintEnabled ? OBJECT_MAPPER.writerWithDefaultPrettyPrinter() : OBJECT_MAPPER.writer();
        this.rootTemplate = builder.rootTemplate;
        this.rootTemplateNode = LogstashLayout.readRootTemplateNode(builder.rootTemplate);
    }

    private static FastDateFormat readDateFormat(Builder builder) {
        TimeZone timeZone = TimeZone.getTimeZone(builder.timeZoneId);
        return FastDateFormat.getInstance((String)builder.dateTimeFormatPattern, (TimeZone)timeZone);
    }

    private static ObjectNode readRootTemplateNode(String rootTemplate) {
        try {
            return rootTemplate == null ? null : (ObjectNode)OBJECT_MAPPER.readValue(rootTemplate, ObjectNode.class);
        }
        catch (IOException error) {
            String message = String.format("failed reading root template (rootTemplate='%s')", rootTemplate);
            throw new RuntimeException(message, error);
        }
    }

    public String toSerializable(LogEvent event) {
        ObjectNode rootNode = this.createRootNode(event);
        this.createFieldsNode(event, rootNode);
        try {
            return this.objectWriter.writeValueAsString((Object)rootNode);
        }
        catch (JsonProcessingException error) {
            throw new RuntimeException("JSON serialization failure", error);
        }
    }

    private ObjectNode createRootNode(LogEvent event) {
        ObjectNode rootNode = this.rootTemplateNode == null ? OBJECT_MAPPER.createObjectNode() : this.rootTemplateNode.deepCopy();
        String timestamp = this.dateTimeFormat.format(event.getTimeMillis());
        rootNode.put("@version", 1);
        rootNode.put("@timestamp", timestamp);
        rootNode.put("@source_host", this.sourceHost);
        rootNode.put("@message", event.getMessage().getFormattedMessage());
        return rootNode;
    }

    private void createFieldsNode(LogEvent event, ObjectNode rootNode) {
        ObjectNode fieldsNode = rootNode.putObject("@fields");
        fieldsNode.put("logger_name", event.getLoggerName());
        fieldsNode.put("level", event.getLevel().toString());
        fieldsNode.put("thread_name", event.getThreadName());
        this.addThrown(event, fieldsNode);
        this.addSource(event, fieldsNode);
        this.addContextData(event, fieldsNode);
        this.addContextStack(event, fieldsNode);
    }

    private void addThrown(LogEvent event, ObjectNode fieldsNode) {
        Throwable thrown = event.getThrown();
        if (thrown != null) {
            ObjectNode exceptionNode = fieldsNode.putObject("exception");
            this.addThrownClassName(thrown, exceptionNode);
            this.addThrownMessage(thrown, exceptionNode);
            this.addThrownStackTrace(thrown, exceptionNode);
        }
    }

    private void addThrownClassName(Throwable thrown, ObjectNode exceptionNode) {
        String thrownClassName = thrown.getClass().getCanonicalName();
        if (thrownClassName != null) {
            exceptionNode.put("exception_class", thrownClassName);
        }
    }

    private void addThrownMessage(Throwable thrown, ObjectNode exceptionNode) {
        String thrownMessage = thrown.getMessage();
        if (thrownMessage != null) {
            exceptionNode.put("exception_message", thrownMessage);
        }
    }

    private void addThrownStackTrace(Throwable thrown, ObjectNode exceptionNode) {
        if (this.stackTraceEnabled) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (PrintStream printStream = new PrintStream(outputStream);){
                thrown.printStackTrace(printStream);
            }
            try {
                String stackTrace = outputStream.toString(this.charset.name());
                exceptionNode.put("stacktrace", stackTrace);
            }
            catch (UnsupportedEncodingException error) {
                throw new RuntimeException("failed converting the stack trace to string", error);
            }
        }
    }

    private void addSource(LogEvent event, ObjectNode fieldsNode) {
        StackTraceElement eventSource = event.getSource();
        if (this.locationInfoEnabled && eventSource != null) {
            fieldsNode.put("file", eventSource.getFileName());
            fieldsNode.put("line_number", eventSource.getLineNumber());
            fieldsNode.put("class", eventSource.getClassName());
            fieldsNode.put("method", eventSource.getMethodName());
        }
    }

    private void addContextData(LogEvent event, ObjectNode fieldsNode) {
        ReadOnlyStringMap contextData = event.getContextData();
        if (contextData != null && !contextData.isEmpty()) {
            final ObjectNode contextDataNode = fieldsNode.putObject("mdc");
            contextData.forEach((BiConsumer)new BiConsumer<String, String>(){

                public void accept(String key, String value) {
                    contextDataNode.put(key, value);
                }
            });
        }
    }

    private void addContextStack(LogEvent event, ObjectNode fieldsNode) {
        ThreadContext.ContextStack contextStack = event.getContextStack();
        if (contextStack.getDepth() > 0) {
            ArrayNode contextStackNode = fieldsNode.putArray("ndc");
            for (String contextStackItem : contextStack.asList()) {
                contextStackNode.add(contextStackItem);
            }
        }
    }

    public String toString() {
        return "LogstashLayout{charset=" + this.charset + ", prettyPrintEnabled=" + this.prettyPrintEnabled + ", locationInfoEnabled=" + this.locationInfoEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + ", dateTimeFormat=" + this.dateTimeFormat + ", sourceHost='" + this.sourceHost + '\'' + ", rootTemplate='" + this.rootTemplate + '\'' + '}';
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogstashLayout> {
        @PluginConfiguration
        private Configuration config;
        @PluginBuilderAttribute
        private Charset charset = StandardCharsets.UTF_8;
        @PluginBuilderAttribute
        private boolean prettyPrintEnabled = false;
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = false;
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = false;
        @PluginBuilderAttribute
        private String dateTimeFormatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
        @PluginBuilderAttribute
        private String timeZoneId = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        private String sourceHost = Builder.getLocalHost();
        @PluginBuilderAttribute
        private String rootTemplate;

        private Builder() {
        }

        private static String getLocalHost() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException error) {
                return "localhost";
            }
        }

        public Configuration getConfiguration() {
            return this.config;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.config = configuration;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public String getDateTimeFormatPattern() {
            return this.dateTimeFormatPattern;
        }

        public Builder setDateTimeFormatPattern(String dateTimeFormatPattern) {
            this.dateTimeFormatPattern = dateTimeFormatPattern;
            return this;
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public Builder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public String getSourceHost() {
            return this.sourceHost;
        }

        public Builder setSourceHost(String sourceHost) {
            this.sourceHost = sourceHost;
            return this;
        }

        public String getRootTemplate() {
            return this.rootTemplate;
        }

        public Builder setRootTemplate(String rootTemplate) {
            this.rootTemplate = rootTemplate;
            return this;
        }

        public LogstashLayout build() {
            this.check();
            return new LogstashLayout(this);
        }

        private void check() {
            Builder.checkNotNull(this.config, "config");
            Builder.checkNotNull(this.charset, "charset");
            Builder.checkArgument(Strings.isNotBlank((String)this.dateTimeFormatPattern), "blank dateTimeFormatPattern", new Object[0]);
            Builder.checkArgument(Strings.isNotBlank((String)this.timeZoneId), "blank timeZoneId", new Object[0]);
            Builder.checkArgument(Strings.isNotBlank((String)this.sourceHost), "blank sourceHost", new Object[0]);
        }

        private static void checkNotNull(Object instance, String name) {
            if (instance == null) {
                throw new NullPointerException(name);
            }
        }

        private static void checkArgument(boolean condition, String messageFormat, Object ... messageArguments) {
            if (!condition) {
                String message = String.format(messageFormat, messageArguments);
                throw new IllegalArgumentException(message);
            }
        }

        public String toString() {
            return "Builder{charset=" + this.charset + ", prettyPrintEnabled=" + this.prettyPrintEnabled + ", locationInfoEnabled=" + this.locationInfoEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + ", dateTimeFormatPattern='" + this.dateTimeFormatPattern + '\'' + ", timeZoneId='" + this.timeZoneId + '\'' + ", sourceHost='" + this.sourceHost + '\'' + ", rootTemplate='" + this.rootTemplate + '\'' + '}';
        }
    }

    public static enum FieldName {

        public static final String FIELDS = "@fields";
        public static final String MESSAGE = "@message";
        public static final String SOURCE_HOST = "@source_host";
        public static final String TIMESTAMP = "@timestamp";
        public static final String VERSION = "@version";

        public static enum Fields {

            public static final String CLASS = "class";
            public static final String CONTEXT_DATA = "mdc";
            public static final String CONTEXT_STACK = "ndc";
            public static final String EXCEPTION = "exception";
            public static final String FILE = "file";
            public static final String METHOD = "method";
            public static final String LEVEL = "level";
            public static final String LINE_NUMBER = "line_number";
            public static final String LOGGER_NAME = "logger_name";
            public static final String THREAD_NAME = "thread_name";

            public static enum Exception {

                public static final String EXCEPTION_CLASS = "exception_class";
                public static final String EXCEPTION_MESSAGE = "exception_message";
                public static final String STACKTRACE = "stacktrace";
            }
        }
    }
}

