/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.renderer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class TemplateRenderer {
    private static final Charset JSON_CHARSET = StandardCharsets.UTF_8;
    private static final String JSON_CHARSET_NAME = JSON_CHARSET.name();
    private final StrSubstitutor substitutor;
    private final TemplateResolverContext resolverContext;
    private final ObjectMapper objectMapper;
    private final ObjectNode templateRootNode;
    private final ObjectWriter objectWriter;
    private final Map<String, TemplateResolver> resolverByName;

    private TemplateRenderer(Builder builder) {
        this.substitutor = builder.substitutor;
        this.resolverContext = builder.resolverContext;
        this.objectMapper = this.resolverContext.getObjectMapper();
        this.objectWriter = TemplateRenderer.createObjectWriter(this.objectMapper, builder.prettyPrintEnabled);
        this.templateRootNode = TemplateRenderer.readTemplate(this.objectMapper, builder.template);
        this.resolverByName = TemplateRenderer.createResolverByName(builder.resolvers);
    }

    private static ObjectWriter createObjectWriter(ObjectMapper objectMapper, boolean prettyPrintEnabled) {
        ObjectWriter objectWriter = prettyPrintEnabled ? objectMapper.writerWithDefaultPrettyPrinter() : objectMapper.writer();
        return objectWriter.withoutFeatures(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
    }

    private static ObjectNode readTemplate(ObjectMapper objectMapper, String template) {
        try {
            return (ObjectNode)objectMapper.readValue(template, ObjectNode.class);
        }
        catch (IOException error) {
            String message = String.format("failed reading template: %s", template);
            throw new RuntimeException(message, error);
        }
    }

    private static Map<String, TemplateResolver> createResolverByName(Set<TemplateResolver> resolvers) {
        HashMap<String, TemplateResolver> resolverByName = new HashMap<String, TemplateResolver>();
        for (TemplateResolver resolver : resolvers) {
            resolverByName.put(resolver.getName(), resolver);
        }
        return resolverByName;
    }

    public String render(LogEvent event) {
        return this.render(event, this.templateRootNode);
    }

    private String render(LogEvent event, ObjectNode srcRootNode) {
        JsonNode dstRootNode = this.resolveNode(event, (JsonNode)srcRootNode);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, JSON_CHARSET);){
                this.objectWriter.writeValue((Writer)writer, (Object)dstRootNode);
                writer.write(System.lineSeparator());
            }
            return outputStream.toString(JSON_CHARSET_NAME);
        }
        catch (IOException error) {
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    private JsonNode resolveNode(LogEvent event, JsonNode node) {
        JsonNodeType nodeType = node.getNodeType();
        switch (nodeType) {
            case ARRAY: {
                return this.resolveArrayNode(event, node);
            }
            case OBJECT: {
                return this.resolveObjectNode(event, node);
            }
            case STRING: {
                return this.resolveStringNode(event, node);
            }
        }
        return node;
    }

    private JsonNode resolveArrayNode(LogEvent event, JsonNode srcNode) {
        ArrayNode dstNode = this.objectMapper.createArrayNode();
        for (int nodeIndex = 0; nodeIndex < srcNode.size(); ++nodeIndex) {
            JsonNode srcChildNode = srcNode.get(nodeIndex);
            JsonNode dstChildNode = this.resolveNode(event, srcChildNode);
            if (dstChildNode == null) continue;
            dstNode.add(dstChildNode);
        }
        return dstNode.size() > 0 ? dstNode : null;
    }

    private JsonNode resolveObjectNode(LogEvent event, JsonNode srcNode) {
        ObjectNode dstNode = this.objectMapper.createObjectNode();
        Iterator srcNodeFieldIterator = srcNode.fields();
        while (srcNodeFieldIterator.hasNext()) {
            Map.Entry srcNodeField = (Map.Entry)srcNodeFieldIterator.next();
            String key = (String)srcNodeField.getKey();
            JsonNode value = (JsonNode)srcNodeField.getValue();
            JsonNode resolvedValue = this.resolveNode(event, value);
            if (resolvedValue == null) continue;
            dstNode.set(key, resolvedValue);
        }
        return dstNode.size() > 0 ? dstNode : null;
    }

    private JsonNode resolveStringNode(LogEvent event, JsonNode textNode) {
        String fieldValue = textNode.asText();
        TemplateResolverRequest resolverRequest = TemplateRenderer.readResolverRequest(fieldValue);
        if (resolverRequest != null) {
            TemplateResolver resolver = this.resolverByName.get(resolverRequest.resolverName);
            if (resolver != null) {
                return resolver.resolve(this.resolverContext, event, resolverRequest.resolverKey);
            }
        } else {
            String replacedText = this.substitutor.replace(event, fieldValue);
            return new TextNode(replacedText);
        }
        return textNode;
    }

    private static TemplateResolverRequest readResolverRequest(String fieldValue) {
        if (!fieldValue.startsWith("${json:") || !fieldValue.endsWith("}")) {
            return null;
        }
        int resolverNameStartIndex = 7;
        int fieldNameSeparatorIndex = fieldValue.indexOf(58, resolverNameStartIndex);
        if (fieldNameSeparatorIndex < 0) {
            int resolverNameEndIndex = fieldValue.length() - 1;
            String resolverName = fieldValue.substring(resolverNameStartIndex, resolverNameEndIndex);
            return new TemplateResolverRequest(resolverName, null);
        }
        int resolverNameEndIndex = fieldNameSeparatorIndex;
        int resolverKeyStartIndex = fieldNameSeparatorIndex + 1;
        int resolverKeyEndIndex = fieldValue.length() - 1;
        String resolverName = fieldValue.substring(resolverNameStartIndex, resolverNameEndIndex);
        String resolverKey = fieldValue.substring(resolverKeyStartIndex, resolverKeyEndIndex);
        return new TemplateResolverRequest(resolverName, resolverKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private StrSubstitutor substitutor;
        private TemplateResolverContext resolverContext;
        private boolean prettyPrintEnabled;
        private String template;
        private Set<TemplateResolver> resolvers;

        private Builder() {
        }

        public StrSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        public Builder setSubstitutor(StrSubstitutor substitutor) {
            this.substitutor = substitutor;
            return this;
        }

        public TemplateResolverContext getResolverContext() {
            return this.resolverContext;
        }

        public Builder setResolverContext(TemplateResolverContext resolverContext) {
            this.resolverContext = resolverContext;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public String getTemplate() {
            return this.template;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Set<TemplateResolver> getResolvers() {
            return this.resolvers;
        }

        public Builder setResolvers(Set<TemplateResolver> resolvers) {
            this.resolvers = resolvers;
            return this;
        }

        public TemplateRenderer build() {
            this.validate();
            return new TemplateRenderer(this);
        }

        private void validate() {
            Validate.notNull((Object)this.substitutor, (String)"substitutor", (Object[])new Object[0]);
            Validate.notNull((Object)this.resolverContext, (String)"resolverContext", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.template, (String)"template", (Object[])new Object[0]);
            Validate.notNull(this.resolvers, (String)"resolvers", (Object[])new Object[0]);
        }
    }

    private static class TemplateResolverRequest {
        private final String resolverName;
        private final String resolverKey;

        private TemplateResolverRequest(String resolverName, String resolverKey) {
            this.resolverName = resolverName;
            this.resolverKey = resolverKey;
        }
    }
}

