/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vlkan.log4j2.logstash.layout.renderer.TemplateRenderer;
import com.vlkan.log4j2.logstash.layout.resolver.ContextDataResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ContextStackResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionClassNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionMessageResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionRootCauseClassNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionRootCauseMessageResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionRootCauseStackTraceResolver;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionStackTraceResolver;
import com.vlkan.log4j2.logstash.layout.resolver.LevelResolver;
import com.vlkan.log4j2.logstash.layout.resolver.LoggerNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.MessageResolver;
import com.vlkan.log4j2.logstash.layout.resolver.SourceClassNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.SourceFileNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.SourceLineNumberResolver;
import com.vlkan.log4j2.logstash.layout.resolver.SourceMethodNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.ThreadNameResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TimestampResolver;
import com.vlkan.log4j2.logstash.layout.util.Uris;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

@Plugin(name="LogstashLayout", category="Core", elementType="layout", printObject=true)
public class LogstashLayout
extends AbstractStringLayout {
    private static final Set<TemplateResolver> RESOLVERS = Collections.unmodifiableSet(new HashSet<TemplateResolver>(Arrays.asList(ContextDataResolver.getInstance(), ContextStackResolver.getInstance(), ExceptionClassNameResolver.getInstance(), ExceptionMessageResolver.getInstance(), ExceptionRootCauseClassNameResolver.getInstance(), ExceptionRootCauseMessageResolver.getInstance(), ExceptionRootCauseStackTraceResolver.getInstance(), ExceptionStackTraceResolver.getInstance(), LevelResolver.getInstance(), LoggerNameResolver.getInstance(), MessageResolver.getInstance(), SourceClassNameResolver.getInstance(), SourceFileNameResolver.getInstance(), SourceLineNumberResolver.getInstance(), SourceMethodNameResolver.getInstance(), ThreadNameResolver.getInstance(), TimestampResolver.getInstance())));
    private final TemplateRenderer renderer;

    private LogstashLayout(Builder builder) {
        super(builder.config, StandardCharsets.UTF_8, null, null);
        String template = LogstashLayout.readTemplate(builder);
        FastDateFormat timestampFormat = LogstashLayout.readDateFormat(builder);
        ObjectMapper objectMapper = new ObjectMapper();
        StrSubstitutor substitutor = builder.config.getStrSubstitutor();
        TemplateResolverContext resolverContext = TemplateResolverContext.newBuilder().setObjectMapper(objectMapper).setTimestampFormat(timestampFormat).setLocationInfoEnabled(builder.locationInfoEnabled).setStackTraceEnabled(builder.stackTraceEnabled).setEmptyPropertyExclusionEnabled(builder.emptyPropertyExclusionEnabled).setMdcKeyPattern(builder.mdcKeyPattern).setNdcPattern(builder.ndcPattern).build();
        this.renderer = TemplateRenderer.newBuilder().setSubstitutor(substitutor).setResolverContext(resolverContext).setPrettyPrintEnabled(builder.prettyPrintEnabled).setTemplate(template).setResolvers(RESOLVERS).build();
    }

    private static String readTemplate(Builder builder) {
        return StringUtils.isBlank((CharSequence)builder.template) ? Uris.readUri(builder.templateUri) : builder.template;
    }

    private static FastDateFormat readDateFormat(Builder builder) {
        TimeZone timeZone = TimeZone.getTimeZone(builder.timeZoneId);
        return FastDateFormat.getInstance((String)builder.dateTimeFormatPattern, (TimeZone)timeZone);
    }

    public String toSerializable(LogEvent event) {
        return this.renderer.render(event);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogstashLayout> {
        @PluginConfiguration
        private Configuration config;
        @PluginBuilderAttribute
        private boolean prettyPrintEnabled = false;
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = false;
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = false;
        @PluginBuilderAttribute
        private boolean emptyPropertyExclusionEnabled = true;
        @PluginBuilderAttribute
        private String dateTimeFormatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
        @PluginBuilderAttribute
        private String timeZoneId = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        private String template = null;
        @PluginBuilderAttribute
        private String templateUri = "classpath:LogstashJsonEventLayoutV1.json";
        @PluginBuilderAttribute
        private String mdcKeyPattern;
        @PluginBuilderAttribute
        private String ndcPattern;

        private Builder() {
        }

        public Configuration getConfiguration() {
            return this.config;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.config = configuration;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public boolean isEmptyPropertyExclusionEnabled() {
            return this.emptyPropertyExclusionEnabled;
        }

        public Builder setEmptyPropertyExclusionEnabled(boolean blankPropertyExclusionEnabled) {
            this.emptyPropertyExclusionEnabled = blankPropertyExclusionEnabled;
            return this;
        }

        public String getDateTimeFormatPattern() {
            return this.dateTimeFormatPattern;
        }

        public Builder setDateTimeFormatPattern(String dateTimeFormatPattern) {
            this.dateTimeFormatPattern = dateTimeFormatPattern;
            return this;
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public Builder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public String getTemplate() {
            return this.template;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public String getTemplateUri() {
            return this.templateUri;
        }

        public Builder setTemplateUri(String templateUri) {
            this.templateUri = templateUri;
            return this;
        }

        public String getMdcKeyPattern() {
            return this.mdcKeyPattern;
        }

        public Builder setMdcKeyPattern(String mdcKeyPattern) {
            this.mdcKeyPattern = mdcKeyPattern;
            return this;
        }

        public String getNdcPattern() {
            return this.ndcPattern;
        }

        public Builder setNdcPattern(String ndcPattern) {
            this.ndcPattern = ndcPattern;
            return this;
        }

        public LogstashLayout build() {
            this.validate();
            return new LogstashLayout(this);
        }

        private void validate() {
            Validate.notNull((Object)this.config, (String)"config", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.dateTimeFormatPattern, (String)"dateTimeFormatPattern", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.timeZoneId, (String)"timeZoneId", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)this.template) || !StringUtils.isBlank((CharSequence)this.templateUri) ? 1 : 0) != 0, (String)"both template and templateUri are blank", (Object[])new Object[0]);
        }

        public String toString() {
            return "Builder{prettyPrintEnabled=" + this.prettyPrintEnabled + ", locationInfoEnabled=" + this.locationInfoEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + ", emptyPropertyExclusionEnabled=" + this.emptyPropertyExclusionEnabled + ", dateTimeFormatPattern='" + this.dateTimeFormatPattern + '\'' + ", timeZoneId='" + this.timeZoneId + '\'' + ", template='" + this.template + '\'' + ", templateUri='" + this.templateUri + '\'' + ", mdcKeyPattern='" + this.mdcKeyPattern + '\'' + ", ndcPattern='" + this.ndcPattern + '\'' + '}';
        }
    }
}

